/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.common;

import com.tangzc.mpe.common.EntityMapperManager;
import com.tangzc.mpe.util.BeanClassUtil;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ApplicationStartListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationStartListener.class);
    @Resource
    private List<EntityFieldScanner> scanners;

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        EntityMapperManager.initEntityMapper();
        List<Class<?>> entityList = EntityMapperManager.getEntityList();
        for (Class<?> entityClass : entityList) {
            List<Field> allDeclaredFields = BeanClassUtil.getAllDeclaredFields(entityClass);
            for (Field field : allDeclaredFields) {
                this.scanners.forEach(scanner -> scanner.scan(entityClass, field));
            }
        }
    }

    @FunctionalInterface
    public static interface EntityFieldScanner {
        public void scan(Class<?> var1, Field var2);
    }
}

