/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.common;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.tangzc.mpe.util.ReflectionUtil;
import com.tangzc.mpe.util.SpringContextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityMapperManager {
    private static final Logger log = LoggerFactory.getLogger(EntityMapperManager.class);
    public static final Map<Class<?>, BaseMapper<?>> ENTITY_MAPPER_CACHE_MAP = new ConcurrentHashMap();

    public static <ENTITY> BaseMapper<ENTITY> getMapper(Class<ENTITY> entityClass) {
        BaseMapper<?> baseMapper = ENTITY_MAPPER_CACHE_MAP.get(entityClass);
        if (baseMapper == null) {
            throw new RuntimeException("\u672a\u53d1\u73b0" + entityClass.getName() + "\u7684BaseMapper\u5b9e\u73b0");
        }
        return baseMapper;
    }

    public static List<Class<?>> getEntityList() {
        return new ArrayList(ENTITY_MAPPER_CACHE_MAP.keySet());
    }

    public static List<BaseMapper<?>> getMapperList() {
        return new ArrayList(ENTITY_MAPPER_CACHE_MAP.values());
    }

    public static void initEntityMapper() {
        List<BaseMapper> proxyMapperList = SpringContextUtil.getBeansOfTypeList(BaseMapper.class);
        for (BaseMapper proxyMapper : proxyMapperList) {
            Class entityClass = ReflectionUtil.getEntityClass(proxyMapper);
            ENTITY_MAPPER_CACHE_MAP.put(entityClass, proxyMapper);
        }
    }
}

