/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.datasource;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.tangzc.mpe.common.ApplicationStartListener;
import com.tangzc.mpe.common.EntityMapperManager;
import com.tangzc.mpe.datasource.metadata.DataSourceDescription;
import com.tangzc.mpe.datasource.metadata.annotation.DataSource;
import com.tangzc.mpe.datasource.metadata.event.EntityUpdateEvent;
import com.tangzc.mpe.util.BeanClassUtil;
import com.tangzc.mpe.util.TableColumnUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class DataSourceManager
implements ApplicationListener<EntityUpdateEvent<?>>,
ApplicationStartListener.EntityFieldScanner {
    private static final Logger log = LoggerFactory.getLogger(DataSourceManager.class);
    private static final Map<String, List<DataSourceDescription>> ENTITY_LIST_MAP = new HashMap<String, List<DataSourceDescription>>();
    private static final Map<String, Map<DescriptionSignature, List<DataSourceDescription>>> ENTITY_GROUP_CACHE_MAP = new HashMap<String, Map<DescriptionSignature, List<DataSourceDescription>>>();
    private static final Map<String, Map<String, Method>> ENTITY_FIELD_METHOD_CACHE_MAP = new HashMap<String, Map<String, Method>>();

    @Override
    public void scan(Class<?> entityClass, Field field) {
        DataSource dataSource = (DataSource)AnnotationUtils.findAnnotation((AnnotatedElement)field, DataSource.class);
        if (dataSource == null) {
            return;
        }
        if (StringUtils.isEmpty((Object)dataSource.sourceName()) && dataSource.source() == Void.class) {
            log.error("{}\u7c7b\u4e0a\u7684{}\u5b57\u6bb5\uff0c@DataSource\u7f3a\u5c11`source`\u6216`sourceName`\u5c5e\u6027\uff0c\u81ea\u52a8\u66f4\u65b0\u6570\u636e\u529f\u80fd\u5c06\u88ab\u5ffd\u7565", entityClass, (Object)field.getName());
            return;
        }
        String sourceName = dataSource.sourceName();
        if (StringUtils.isEmpty((Object)sourceName)) {
            sourceName = dataSource.source().getName();
        }
        ENTITY_LIST_MAP.computeIfAbsent(sourceName, k -> new ArrayList()).add(new DataSourceDescription(entityClass, field, dataSource));
    }

    public void onApplicationEvent(EntityUpdateEvent<?> entityUpdateEvent) {
        String entityName = entityUpdateEvent.getEntityName();
        Map descListGroup = ENTITY_GROUP_CACHE_MAP.computeIfAbsent(entityName, k -> {
            List<DataSourceDescription> dataSourceDescriptions = ENTITY_LIST_MAP.get(entityName);
            if (dataSourceDescriptions == null) {
                return Collections.emptyMap();
            }
            return dataSourceDescriptions.stream().collect(Collectors.groupingBy(this::groupBy));
        });
        for (Map.Entry descListEntry : descListGroup.entrySet()) {
            DescriptionSignature description = (DescriptionSignature)descListEntry.getKey();
            List descList = (List)descListEntry.getValue();
            this.executeUpdate(entityUpdateEvent, description, descList);
        }
    }

    private <E> void executeUpdate(EntityUpdateEvent<?> entityUpdateEvent, DescriptionSignature description, List<DataSourceDescription> descList) {
        Class<?> entityClass = description.getEntityClass();
        BaseMapper<?> mapper = EntityMapperManager.getMapper(entityClass);
        UpdateWrapper updateWrapper = null;
        String updateEntityName = entityUpdateEvent.getEntityName();
        Class<?> updateEntityClass = entityUpdateEvent.getEntityClass();
        for (DataSourceDescription desc : descList) {
            String fieldName = desc.getDataSource().field();
            if (!entityUpdateEvent.getFields().isEmpty() && !entityUpdateEvent.getFields().contains(fieldName)) continue;
            if (updateWrapper == null) {
                updateWrapper = Wrappers.update();
            }
            try {
                Method readMethod = ENTITY_FIELD_METHOD_CACHE_MAP.computeIfAbsent(updateEntityName, k -> new HashMap(1)).computeIfAbsent(fieldName, k -> BeanClassUtil.getReadMethod(updateEntityClass, fieldName));
                Object val = readMethod.invoke(entityUpdateEvent.getEntity(), new Object[0]);
                updateWrapper.set((Object)TableColumnUtil.humpToLine(desc.getEntityField().getName()), val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (updateWrapper != null) {
            for (ConditionSignature condition : description.conditions) {
                try {
                    Method readMethod = ENTITY_FIELD_METHOD_CACHE_MAP.computeIfAbsent(updateEntityName, k -> new HashMap(1)).computeIfAbsent(condition.sourceField, k -> BeanClassUtil.getReadMethod(updateEntityClass, condition.sourceField));
                    Object val = readMethod.invoke(entityUpdateEvent.getEntity(), new Object[0]);
                    updateWrapper.eq((Object)TableColumnUtil.humpToLine(condition.selfField), val);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            mapper.update(null, updateWrapper);
        }
    }

    private DescriptionSignature groupBy(DataSourceDescription desc) {
        return new DescriptionSignature(desc.getEntityClass(), Arrays.stream(desc.getDataSource().condition()).map(con -> new ConditionSignature(con.selfField(), con.sourceField())).collect(Collectors.toList()));
    }

    private static class ConditionSignature {
        private String selfField;
        private String sourceField;

        public String getSelfField() {
            return this.selfField;
        }

        public String getSourceField() {
            return this.sourceField;
        }

        public void setSelfField(String selfField) {
            this.selfField = selfField;
        }

        public void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionSignature)) {
                return false;
            }
            ConditionSignature other = (ConditionSignature)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$selfField = this.getSelfField();
            String other$selfField = other.getSelfField();
            if (this$selfField == null ? other$selfField != null : !this$selfField.equals(other$selfField)) {
                return false;
            }
            String this$sourceField = this.getSourceField();
            String other$sourceField = other.getSourceField();
            return !(this$sourceField == null ? other$sourceField != null : !this$sourceField.equals(other$sourceField));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConditionSignature;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $selfField = this.getSelfField();
            result = result * 59 + ($selfField == null ? 43 : $selfField.hashCode());
            String $sourceField = this.getSourceField();
            result = result * 59 + ($sourceField == null ? 43 : $sourceField.hashCode());
            return result;
        }

        public String toString() {
            return "DataSourceManager.ConditionSignature(selfField=" + this.getSelfField() + ", sourceField=" + this.getSourceField() + ")";
        }

        public ConditionSignature(String selfField, String sourceField) {
            this.selfField = selfField;
            this.sourceField = sourceField;
        }
    }

    private static class DescriptionSignature {
        private Class<?> entityClass;
        private List<ConditionSignature> conditions;

        public Class<?> getEntityClass() {
            return this.entityClass;
        }

        public List<ConditionSignature> getConditions() {
            return this.conditions;
        }

        public void setEntityClass(Class<?> entityClass) {
            this.entityClass = entityClass;
        }

        public void setConditions(List<ConditionSignature> conditions) {
            this.conditions = conditions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DescriptionSignature)) {
                return false;
            }
            DescriptionSignature other = (DescriptionSignature)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$entityClass = this.getEntityClass();
            Class<?> other$entityClass = other.getEntityClass();
            if (this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass)) {
                return false;
            }
            List<ConditionSignature> this$conditions = this.getConditions();
            List<ConditionSignature> other$conditions = other.getConditions();
            return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DescriptionSignature;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $entityClass = this.getEntityClass();
            result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
            List<ConditionSignature> $conditions = this.getConditions();
            result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
            return result;
        }

        public String toString() {
            return "DataSourceManager.DescriptionSignature(entityClass=" + this.getEntityClass() + ", conditions=" + this.getConditions() + ")";
        }

        public DescriptionSignature(Class<?> entityClass, List<ConditionSignature> conditions) {
            this.entityClass = entityClass;
            this.conditions = conditions;
        }
    }
}

