/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.fixedcondition;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.tangzc.mpe.fixedcondition.FixedConditionManager;
import com.tangzc.mpe.fixedcondition.metadata.FixedConditionDescription;
import com.tangzc.mpe.util.TableColumnUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedConditionInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(FixedConditionInterceptor.class);

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.changeSql(mpBs.sql()));
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.changeSql(mpBs.sql()));
        }
    }

    protected String changeSql(String sql) {
        Statement statement = null;
        try {
            statement = CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
        }
        return this.processParser(statement, 0, sql, null);
    }

    protected void processInsert(Insert insert, int index, String sql, Object obj) {
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        String tableName = TableColumnUtil.getTableName(delete.getTable());
        List<FixedConditionDescription> descriptions = FixedConditionManager.get(tableName);
        if (descriptions == null) {
            return;
        }
        Expression where = this.getExpression(descriptions, delete.getWhere());
        delete.setWhere(where);
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
        String tableName = TableColumnUtil.getTableName(update.getTable());
        List<FixedConditionDescription> descriptions = FixedConditionManager.get(tableName);
        if (descriptions == null) {
            return;
        }
        Expression where = this.getExpression(descriptions, update.getWhere());
        update.setWhere(where);
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        this.processSelectBody(select.getSelectBody());
    }

    private void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSelectBody() != null) {
                this.processSelectBody(withItem.getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                operationList.getSelects().forEach(this::processSelectBody);
            }
        }
    }

    private void processPlainSelect(PlainSelect plainSelect) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            String tableName = TableColumnUtil.getTableName((Table)fromItem);
            List<FixedConditionDescription> descriptions = FixedConditionManager.get(tableName);
            if (descriptions == null) {
                return;
            }
            Expression where = this.getExpression(descriptions, plainSelect.getWhere());
            plainSelect.setWhere(where);
        }
    }

    private Expression getExpression(List<FixedConditionDescription> descriptions, Expression where) {
        try {
            for (FixedConditionDescription description : descriptions) {
                Field entityField = description.getEntityField();
                String value = description.getFixedCondition().value();
                Class<?> type = entityField.getType();
                if (type == String.class) {
                    value = "'" + value + "'";
                }
                Expression envCondition = CCJSqlParserUtil.parseCondExpression((String)(TableColumnUtil.getColumnName(entityField) + "=" + value));
                where = new AndExpression(where, envCondition);
            }
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
        }
        return where;
    }
}

