/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.relevance;

import com.tangzc.mpe.relevance.Binder;
import com.tangzc.mpe.relevance.builder.ConditionSign;
import com.tangzc.mpe.relevance.builder.ResultBuilder;
import com.tangzc.mpe.relevance.metadata.BindEntityDescription;
import com.tangzc.mpe.relevance.metadata.FieldDescription;
import com.tangzc.mpe.relevance.metadata.JoinConditionDescription;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BindEntityBinder<BEAN>
implements Binder.IBinder<BEAN, BindEntityDescription, JoinConditionDescription> {
    private static final Logger log = LoggerFactory.getLogger(BindEntityBinder.class);

    @Override
    public <ENTITY> void fillData(List<BEAN> beans, ConditionSign<ENTITY, JoinConditionDescription> conditionSign, List<BindEntityDescription> fieldAnnotations) {
        ResultBuilder.newInstance(beans, conditionSign, fieldAnnotations, new ResultBuilder.FillDataCallback(){

            @Override
            public void fillBefore(Object bean, FieldDescription<?, JoinConditionDescription> fieldAnnotation, List<?> entities) {
                if (((BindEntityDescription)fieldAnnotation).isDeepBind()) {
                    Binder.bind(entities, Collections.emptyList(), Collections.emptyList());
                }
            }

            @Override
            public List<?> changeDataList(Object bean, FieldDescription<?, JoinConditionDescription> fieldAnnotation, List<?> entities) {
                BindEntityDescription entityDescription = (BindEntityDescription)fieldAnnotation;
                if (entityDescription.getEntityClass() != entityDescription.getFieldClass()) {
                    return entities.stream().map(entity -> {
                        try {
                            Object newInstance = entityDescription.getFieldClass().newInstance();
                            BeanUtils.copyProperties((Object)entity, newInstance);
                            return newInstance;
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            throw new RuntimeException(entityDescription.getEntityClass() + "\u8f6c" + entityDescription.getFieldClass() + "\u7684\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef\u3002", e);
                        }
                    }).collect(Collectors.toList());
                }
                return entities;
            }
        }).fillData();
    }

    private BindEntityBinder() {
    }

    public static <BEAN> BindEntityBinder<BEAN> newInstance() {
        return new BindEntityBinder<BEAN>();
    }
}

