/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.relevance;

import com.tangzc.mpe.relevance.Binder;
import com.tangzc.mpe.relevance.builder.ByMidResultBuilder;
import com.tangzc.mpe.relevance.builder.ConditionSign;
import com.tangzc.mpe.relevance.metadata.BindEntityByMidDescription;
import com.tangzc.mpe.relevance.metadata.FieldDescription;
import com.tangzc.mpe.relevance.metadata.MidConditionDescription;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BindEntityByMidBinder<BEAN>
implements Binder.IBinder<BEAN, BindEntityByMidDescription, MidConditionDescription> {
    private static final Logger log = LoggerFactory.getLogger(BindEntityByMidBinder.class);

    @Override
    public <ENTITY> void fillData(List<BEAN> beans, ConditionSign<ENTITY, MidConditionDescription> conditionSign, List<BindEntityByMidDescription> fieldAnnotations) {
        ByMidResultBuilder.newInstance(beans, conditionSign, fieldAnnotations, new ByMidResultBuilder.FillDataCallback(){

            @Override
            public void fillBefore(Object bean, FieldDescription<?, MidConditionDescription> fieldAnnotation, List<?> entities) {
                if (((BindEntityByMidDescription)fieldAnnotation).isDeepBind()) {
                    Binder.bind(entities, Collections.emptyList(), Collections.emptyList());
                }
            }

            @Override
            public List<?> changeDataList(Object bean, FieldDescription<?, MidConditionDescription> fieldAnnotation, List<?> entities) {
                BindEntityByMidDescription entityDescription = (BindEntityByMidDescription)fieldAnnotation;
                if (entityDescription.getEntityClass() != entityDescription.getFieldClass()) {
                    return entities.stream().map(entity -> {
                        try {
                            Object newInstance = entityDescription.getFieldClass().newInstance();
                            BeanUtils.copyProperties((Object)entity, newInstance);
                            return newInstance;
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            throw new RuntimeException(entityDescription.getEntityClass() + "\u8f6c" + entityDescription.getFieldClass() + "\u7684\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef\u3002", e);
                        }
                    }).collect(Collectors.toList());
                }
                return entities;
            }
        }).fillData();
    }

    private BindEntityByMidBinder() {
    }

    public static <BEAN> BindEntityByMidBinder<BEAN> newInstance() {
        return new BindEntityByMidBinder<BEAN>();
    }
}

