/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.relevance;

import com.tangzc.mpe.relevance.Binder;
import com.tangzc.mpe.relevance.builder.ConditionSign;
import com.tangzc.mpe.relevance.builder.ResultBuilder;
import com.tangzc.mpe.relevance.metadata.BindFieldDescription;
import com.tangzc.mpe.relevance.metadata.FieldDescription;
import com.tangzc.mpe.relevance.metadata.JoinConditionDescription;
import com.tangzc.mpe.relevance.metadata.annotation.BindField;
import com.tangzc.mpe.util.TableColumnUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindFieldBinder<BEAN>
implements Binder.IBinder<BEAN, BindFieldDescription, JoinConditionDescription> {
    private static final Logger log = LoggerFactory.getLogger(BindFieldBinder.class);

    @Override
    public <ENTITY> void fillData(List<BEAN> beans, ConditionSign<ENTITY, JoinConditionDescription> conditionSign, final List<BindFieldDescription> fieldAnnotations) {
        ResultBuilder.newInstance(beans, conditionSign, fieldAnnotations, new ResultBuilder.FillDataCallback(){

            @Override
            public String[] selectColumns(List<?> beans, ConditionSign<?, JoinConditionDescription> entityJoinCondition, List<? extends FieldDescription<?, JoinConditionDescription>> fieldAnnotationList) {
                List<String> columns = fieldAnnotations.stream().map(bfd -> ((BindField)bfd.getBindAnnotation()).field()).map(TableColumnUtil::humpToLine).collect(Collectors.toList());
                for (JoinConditionDescription condition : entityJoinCondition.getConditions()) {
                    columns.add(TableColumnUtil.humpToLine(condition.getJoinField()));
                }
                return columns.toArray(new String[0]);
            }

            @Override
            public List<?> changeDataList(Object bean, FieldDescription<?, JoinConditionDescription> fieldAnnotation, List<?> entities) {
                return entities.stream().map(entity -> {
                    try {
                        return ((BindFieldDescription)fieldAnnotation).getBindFieldGetMethod().invoke(entity, new Object[0]);
                    }
                    catch (Exception e) {
                        log.error("\u7ed1\u5b9a\u5c5e\u6027\u83b7\u53d6\u503c\u5931\u8d25", (Throwable)e);
                        return null;
                    }
                }).collect(Collectors.toList());
            }
        }).fillData();
    }

    private BindFieldBinder() {
    }

    public static <BEAN> BindFieldBinder<BEAN> newInstance() {
        return new BindFieldBinder<BEAN>();
    }
}

