/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.relevance;

import com.tangzc.mpe.relevance.Binder;
import com.tangzc.mpe.relevance.builder.ByMidResultBuilder;
import com.tangzc.mpe.relevance.builder.ConditionSign;
import com.tangzc.mpe.relevance.metadata.BindFieldByMidDescription;
import com.tangzc.mpe.relevance.metadata.FieldDescription;
import com.tangzc.mpe.relevance.metadata.MidConditionDescription;
import com.tangzc.mpe.relevance.metadata.annotation.BindFieldByMid;
import com.tangzc.mpe.util.TableColumnUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindFieldByMidBinder<BEAN>
implements Binder.IBinder<BEAN, BindFieldByMidDescription, MidConditionDescription> {
    private static final Logger log = LoggerFactory.getLogger(BindFieldByMidBinder.class);

    @Override
    public <ENTITY> void fillData(List<BEAN> beans, ConditionSign<ENTITY, MidConditionDescription> conditionSign, final List<BindFieldByMidDescription> fieldAnnotations) {
        ByMidResultBuilder.newInstance(beans, conditionSign, fieldAnnotations, new ByMidResultBuilder.FillDataCallback(){

            @Override
            public String[] selectColumns(List<?> beans, ConditionSign<?, MidConditionDescription> conditionSign, List<? extends FieldDescription<?, MidConditionDescription>> fieldDescriptions) {
                List<String> columns = fieldAnnotations.stream().map(bfd -> ((BindFieldByMid)bfd.getBindAnnotation()).field()).map(TableColumnUtil::humpToLine).collect(Collectors.toList());
                for (MidConditionDescription condition : conditionSign.getConditions()) {
                    columns.add(TableColumnUtil.humpToLine(condition.getJoinField()));
                }
                return columns.toArray(new String[0]);
            }

            @Override
            public List<?> changeDataList(Object bean, FieldDescription<?, MidConditionDescription> fieldAnnotation, List<?> entities) {
                return entities.stream().map(entity -> {
                    try {
                        return ((BindFieldByMidDescription)fieldAnnotation).getBindFieldGetMethod().invoke(entity, new Object[0]);
                    }
                    catch (Exception e) {
                        log.error("\u7ed1\u5b9a\u5c5e\u6027\u83b7\u53d6\u503c\u5931\u8d25", (Throwable)e);
                        return null;
                    }
                }).collect(Collectors.toList());
            }
        }).fillData();
    }

    private BindFieldByMidBinder() {
    }

    public static <BEAN> BindFieldByMidBinder<BEAN> newInstance() {
        return new BindFieldByMidBinder<BEAN>();
    }
}

