/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.relevance;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.tangzc.mpe.relevance.BindEntityBinder;
import com.tangzc.mpe.relevance.BindEntityByMidBinder;
import com.tangzc.mpe.relevance.BindFieldBinder;
import com.tangzc.mpe.relevance.BindFieldByMidBinder;
import com.tangzc.mpe.relevance.builder.ConditionSign;
import com.tangzc.mpe.relevance.manager.BeanAnnotationManager;
import com.tangzc.mpe.relevance.metadata.BeanDescription;
import com.tangzc.mpe.relevance.metadata.FieldDescription;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Binder {
    private static final Logger log = LoggerFactory.getLogger(Binder.class);

    @SafeVarargs
    public static <BEAN> void bindOn(BEAN bean, SFunction<BEAN, ?> firstField, SFunction<BEAN, ?> ... otherFields) {
        if (bean == null) {
            return;
        }
        Binder.bindOn(Collections.singletonList(bean), firstField, otherFields);
    }

    @SafeVarargs
    public static <BEAN> void bindOn(IPage<BEAN> bean, SFunction<BEAN, ?> firstField, SFunction<BEAN, ?> ... otherFields) {
        Binder.bindOn(bean.getRecords(), firstField, otherFields);
    }

    @SafeVarargs
    public static <BEAN> void bindOn(List<BEAN> beans, SFunction<BEAN, ?> firstField, SFunction<BEAN, ?> ... otherFields) {
        ArrayList bindFields = new ArrayList();
        bindFields.add(firstField);
        if (otherFields != null) {
            bindFields.addAll(Arrays.asList(otherFields));
        }
        Binder.bindOn(beans, bindFields);
    }

    public static <BEAN> void bindOn(BEAN bean, List<SFunction<BEAN, ?>> bindFields) {
        if (bean == null) {
            return;
        }
        Binder.bindOn(Collections.singletonList(bean), bindFields);
    }

    public static <BEAN> void bindOn(IPage<BEAN> bean, List<SFunction<BEAN, ?>> bindFields) {
        Binder.bindOn(bean.getRecords(), bindFields);
    }

    public static <BEAN> void bindOn(List<BEAN> beans, List<SFunction<BEAN, ?>> bindFields) {
        ArrayList<String> bindFieldNames = new ArrayList<String>();
        if (bindFields != null) {
            Function<SFunction, String> getFieldName = sf -> {
                LambdaMeta lambda = LambdaUtils.extract((SFunction)sf);
                return PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
            };
            for (SFunction<BEAN, ?> otherField : bindFields) {
                bindFieldNames.add(getFieldName.apply(otherField));
            }
        }
        Binder.bind(beans, bindFieldNames, Collections.emptyList());
    }

    public static <BEAN> void bind(BEAN bean) {
        if (bean == null) {
            return;
        }
        Binder.bind(Collections.singletonList(bean));
    }

    public static <BEAN> void bind(IPage<BEAN> page) {
        if (page == null) {
            return;
        }
        Binder.bind(page.getRecords());
    }

    public static <BEAN> void bind(List<BEAN> beans) {
        if (beans == null) {
            return;
        }
        Binder.bind(beans, Collections.emptyList(), Collections.emptyList());
    }

    public static <BEAN> void bind(List<BEAN> beans, List<String> includeField, List<String> ignoreField) {
        if (CollectionUtils.isEmpty(beans)) {
            return;
        }
        Class<?> beanClass = beans.get(0).getClass();
        BeanDescription<?> beanAnnotation = BeanAnnotationManager.getBeanAnnotation(beanClass, includeField, ignoreField);
        if (beanAnnotation.isValid()) {
            BindFieldBinder.newInstance().doBind(beans, beanAnnotation.getBindFieldAnnotations());
            BindEntityBinder.newInstance().doBind(beans, beanAnnotation.getBindEntityAnnotations());
            BindFieldByMidBinder.newInstance().doBind(beans, beanAnnotation.getBindFieldByMidDescriptions());
            BindEntityByMidBinder.newInstance().doBind(beans, beanAnnotation.getBindEntityByMidAnnotations());
        }
    }

    public static interface IBinder<BEAN, FD extends FieldDescription<? extends Annotation, CONDITION_DESC>, CONDITION_DESC> {
        default public void doBind(List<BEAN> beans, List<FD> fieldDescriptions) {
            if (fieldDescriptions.isEmpty()) {
                return;
            }
            Map<ConditionSign, List<FieldDescription>> fieldAnnotationListGroupByCondition = fieldDescriptions.stream().collect(Collectors.groupingBy(fd -> fd.conditionUniqueKey()));
            fieldAnnotationListGroupByCondition.forEach((entityJoinCondition, fieldAnnotationList) -> this.fillData(beans, (ConditionSign)entityJoinCondition, (List<FD>)fieldAnnotationList));
        }

        public <ENTITY> void fillData(List<BEAN> var1, ConditionSign<ENTITY, CONDITION_DESC> var2, List<FD> var3);
    }
}

