/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.relevance.builder;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.tangzc.mpe.common.EntityMapperManager;
import com.tangzc.mpe.relevance.builder.ConditionSign;
import com.tangzc.mpe.relevance.metadata.FieldDescription;
import com.tangzc.mpe.relevance.metadata.MidConditionDescription;
import com.tangzc.mpe.util.TableColumnUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ByMidResultBuilder<BEAN, ENTITY> {
    private final List<BEAN> beans;
    private final ConditionSign<ENTITY, MidConditionDescription> conditionSign;
    private final List<? extends FieldDescription<?, MidConditionDescription>> fieldDescriptions;
    private final FillDataCallback fillDataCallback;

    public void fillData() {
        Map<String, List<ENTITY>> entityMap = this.listEntitiesByCondition();
        for (BEAN bean : this.beans) {
            String entryGroupKey = this.getGroupKeyOfBean(bean, this.conditionSign);
            List entities = entityMap.getOrDefault(entryGroupKey, Collections.emptyList());
            for (FieldDescription<?, MidConditionDescription> fieldAnnotation : this.fieldDescriptions) {
                List<Object> dataList = entities;
                if (this.fillDataCallback != null) {
                    this.fillDataCallback.fillBefore(bean, fieldAnnotation, dataList);
                    dataList = this.fillDataCallback.changeDataList(bean, fieldAnnotation, dataList);
                }
                this.fullDataToBeanField(bean, fieldAnnotation, dataList);
            }
        }
    }

    private Map<String, List<ENTITY>> listEntitiesByCondition() {
        MidConditionDescription md = this.conditionSign.getConditions().get(0);
        List<Object> midDataList = this.listMidData();
        Map midDataListMap = midDataList.stream().collect(Collectors.groupingBy(midData -> {
            try {
                return md.getSelfMidFieldGetMethod().invoke(midData, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, Collectors.mapping(midData -> {
            try {
                return md.getJoinMidFieldGetMethod().invoke(midData, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, Collectors.toList())));
        List<ENTITY> entities = this.listEntities(md, midDataList);
        Map listMap = entities.stream().collect(Collectors.toMap(ent -> {
            try {
                return md.getJoinFieldGetMethod().invoke(ent, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, Function.identity()));
        HashMap dataMap = new HashMap(midDataListMap.size());
        midDataListMap.forEach((selfVal, joinValList) -> dataMap.put(selfVal.toString(), joinValList.stream().map(listMap::get).collect(Collectors.toList())));
        return dataMap;
    }

    private List<ENTITY> listEntities(MidConditionDescription md, List<Object> midDataList) {
        HashSet<Object> joinMidFieldVals = new HashSet<Object>();
        try {
            for (Object midData : midDataList) {
                joinMidFieldVals.add(md.getJoinMidFieldGetMethod().invoke(midData, new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        String[] selectColumns = this.fillDataCallback.selectColumns(this.beans, this.conditionSign, this.fieldDescriptions);
        if (selectColumns != null && selectColumns.length > 0) {
            queryWrapper.select(selectColumns);
        }
        queryWrapper.in((Object)TableColumnUtil.humpToLine(md.getJoinField()), joinMidFieldVals);
        return EntityMapperManager.getMapper(this.conditionSign.getJoinEntityClass()).selectList((Wrapper)queryWrapper);
    }

    private <MID> List<MID> listMidData() {
        MidConditionDescription midConditionDescription = this.conditionSign.getConditions().get(0);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{TableColumnUtil.humpToLine(midConditionDescription.getJoinMidField()), TableColumnUtil.humpToLine(midConditionDescription.getSelfMidField())});
        ArrayList<Object> selfFieldVals = new ArrayList<Object>();
        try {
            for (BEAN bean : this.beans) {
                selfFieldVals.add(midConditionDescription.getSelfFieldGetMethod().invoke(bean, new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        queryWrapper.in((Object)TableColumnUtil.humpToLine(midConditionDescription.getSelfMidField()), selfFieldVals);
        BaseMapper<?> baseMapper = EntityMapperManager.getMapper(midConditionDescription.getMidEntity());
        return baseMapper.selectList((Wrapper)queryWrapper);
    }

    private void fullDataToBeanField(BEAN bean, FieldDescription<?, MidConditionDescription> fieldAnnotation, List<?> dataList) {
        List<?> val;
        if (fieldAnnotation.isCollection()) {
            val = dataList;
        } else {
            this.checkBindDataSize(bean.getClass().getName(), dataList.size(), fieldAnnotation.getFieldName());
            val = dataList.isEmpty() ? null : dataList.get(0);
        }
        try {
            fieldAnnotation.getSetMethod().invoke(bean, val);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void checkBindDataSize(String beanName, int dataListSize, String fieldName) {
        if (dataListSize > 1) {
            String entityName = this.conditionSign.getJoinEntityClass().getName();
            throw new RuntimeException(beanName + "." + fieldName + "\u5173\u8054" + entityName + "\u7684\u6570\u636e\u6761\u6570\u5927\u4e8e1\u6761");
        }
    }

    private String getGroupKeyOfBean(BEAN bean, ConditionSign<ENTITY, MidConditionDescription> conditionSign) {
        MidConditionDescription midConditionDescription = conditionSign.getConditions().get(0);
        try {
            Object val = midConditionDescription.getSelfFieldGetMethod().invoke(bean, new Object[0]);
            return Optional.ofNullable(val).map(Object::toString).orElse("");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ByMidResultBuilder(List<BEAN> beans, ConditionSign<ENTITY, MidConditionDescription> conditionSign, List<? extends FieldDescription<?, MidConditionDescription>> fieldDescriptions, FillDataCallback fillDataCallback) {
        this.beans = beans;
        this.conditionSign = conditionSign;
        this.fieldDescriptions = fieldDescriptions;
        this.fillDataCallback = fillDataCallback;
    }

    public static <BEAN, ENTITY> ByMidResultBuilder<BEAN, ENTITY> newInstance(List<BEAN> beans, ConditionSign<ENTITY, MidConditionDescription> conditionSign, List<? extends FieldDescription<?, MidConditionDescription>> fieldDescriptions, FillDataCallback fillDataCallback) {
        return new ByMidResultBuilder<BEAN, ENTITY>(beans, conditionSign, fieldDescriptions, fillDataCallback);
    }

    public static interface FillDataCallback {
        default public String[] selectColumns(List<?> beans, ConditionSign<?, MidConditionDescription> conditionSign, List<? extends FieldDescription<?, MidConditionDescription>> fieldAnnotationList) {
            return null;
        }

        default public void fillBefore(Object bean, FieldDescription<?, MidConditionDescription> fieldAnnotation, List<?> entities) {
        }

        default public List<?> changeDataList(Object bean, FieldDescription<?, MidConditionDescription> fieldAnnotation, List<?> entities) {
            return entities;
        }
    }
}

