/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.relevance.builder;

import com.tangzc.mpe.relevance.metadata.OrderByDescription;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConditionSign<ENTITY, CONDITION_DESC> {
    private final Class<ENTITY> joinEntityClass;
    private final List<CONDITION_DESC> conditions;
    private final String customCondition;
    private final List<OrderByDescription> orderBys;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionSign that = (ConditionSign)o;
        String thisConditions = this.getSortConditionStr();
        String thisOrderBys = this.getSortOrderByStr();
        String thatConditions = that.getSortConditionStr();
        String thatCustomCondition = that.getCustomCondition();
        String thatOrderBys = that.getSortOrderByStr();
        return this.joinEntityClass.equals(that.joinEntityClass) && thisConditions.equals(thatConditions) && this.customCondition.equals(thatCustomCondition) && thisOrderBys.equals(thatOrderBys);
    }

    public int hashCode() {
        return Objects.hash(this.joinEntityClass, this.getSortConditionStr(), this.customCondition, this.getSortOrderByStr());
    }

    private String getSortConditionStr() {
        return this.conditions.stream().map(Object::toString).sorted().collect(Collectors.joining("#"));
    }

    private String getSortOrderByStr() {
        return this.orderBys.stream().map(Object::toString).sorted().collect(Collectors.joining("#"));
    }

    public Class<ENTITY> getJoinEntityClass() {
        return this.joinEntityClass;
    }

    public List<CONDITION_DESC> getConditions() {
        return this.conditions;
    }

    public String getCustomCondition() {
        return this.customCondition;
    }

    public List<OrderByDescription> getOrderBys() {
        return this.orderBys;
    }

    public ConditionSign(Class<ENTITY> joinEntityClass, List<CONDITION_DESC> conditions, String customCondition, List<OrderByDescription> orderBys) {
        this.joinEntityClass = joinEntityClass;
        this.conditions = conditions;
        this.customCondition = customCondition;
        this.orderBys = orderBys;
    }
}

