/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.relevance.builder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.tangzc.mpe.common.EntityMapperManager;
import com.tangzc.mpe.relevance.builder.ConditionSign;
import com.tangzc.mpe.relevance.builder.QueryWrapperBuilder;
import com.tangzc.mpe.relevance.metadata.FieldDescription;
import com.tangzc.mpe.relevance.metadata.JoinConditionDescription;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResultBuilder<BEAN, ENTITY> {
    private final List<BEAN> beans;
    private final ConditionSign<ENTITY, JoinConditionDescription> conditionSign;
    private final List<? extends FieldDescription<?, JoinConditionDescription>> fieldDescriptions;
    private final FillDataCallback fillDataCallback;

    public void fillData() {
        Map<String, List<ENTITY>> entityMap = this.listEntitiesByCondition();
        for (BEAN bean : this.beans) {
            String entryGroupKey = this.getGroupKeyOfBean(bean, this.conditionSign);
            List entities = entityMap.getOrDefault(entryGroupKey, Collections.emptyList());
            for (FieldDescription<?, JoinConditionDescription> fieldAnnotation : this.fieldDescriptions) {
                List<Object> dataList = entities;
                if (this.fillDataCallback != null) {
                    this.fillDataCallback.fillBefore(bean, fieldAnnotation, dataList);
                    dataList = this.fillDataCallback.changeDataList(bean, fieldAnnotation, dataList);
                }
                this.fullDataToBeanField(bean, fieldAnnotation, dataList);
            }
        }
    }

    private Map<String, List<ENTITY>> listEntitiesByCondition() {
        List<JoinConditionDescription> conditions = this.conditionSign.getConditions();
        QueryWrapper queryWrapper = QueryWrapperBuilder.newInstance().select(this.fillDataCallback.selectColumns(this.beans, this.conditionSign, this.fieldDescriptions)).where(conditions, this.conditionSign.getCustomCondition()).orderBy(this.conditionSign.getOrderBys()).build(this.beans);
        Class<ENTITY> joinEntityClass = this.conditionSign.getJoinEntityClass();
        BaseMapper<ENTITY> mapper = EntityMapperManager.getMapper(joinEntityClass);
        List entities = mapper.selectList(queryWrapper);
        return entities.stream().collect(Collectors.groupingBy(entity -> this.getGroupKeyOfEntity(entity, this.conditionSign)));
    }

    private void fullDataToBeanField(BEAN bean, FieldDescription<?, JoinConditionDescription> fieldAnnotation, List<?> dataList) {
        List<?> val;
        if (fieldAnnotation.isCollection()) {
            val = dataList;
        } else {
            this.checkBindDataSize(bean.getClass().getName(), dataList.size(), fieldAnnotation.getFieldName());
            val = dataList.isEmpty() ? null : dataList.get(0);
        }
        try {
            fieldAnnotation.getSetMethod().invoke(bean, val);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void checkBindDataSize(String beanName, int dataListSize, String fieldName) {
        if (dataListSize > 1) {
            String entityName = this.conditionSign.getJoinEntityClass().getName();
            throw new RuntimeException(beanName + "." + fieldName + "\u5173\u8054" + entityName + "\u7684\u6570\u636e\u6761\u6570\u5927\u4e8e1\u6761");
        }
    }

    private String getGroupKeyOfBean(BEAN bean, ConditionSign<ENTITY, JoinConditionDescription> conditionSign) {
        return conditionSign.getConditions().stream().map(condition -> {
            try {
                return condition.getJoinField() + "=" + condition.getSelfFieldGetMethod().invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.joining("|"));
    }

    private String getGroupKeyOfEntity(ENTITY entity, ConditionSign<ENTITY, JoinConditionDescription> conditionSign) {
        return conditionSign.getConditions().stream().map(condition -> {
            try {
                return condition.getJoinField() + "=" + condition.getJoinFieldGetMethod().invoke(entity, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.joining("|"));
    }

    private ResultBuilder(List<BEAN> beans, ConditionSign<ENTITY, JoinConditionDescription> conditionSign, List<? extends FieldDescription<?, JoinConditionDescription>> fieldDescriptions, FillDataCallback fillDataCallback) {
        this.beans = beans;
        this.conditionSign = conditionSign;
        this.fieldDescriptions = fieldDescriptions;
        this.fillDataCallback = fillDataCallback;
    }

    public static <BEAN, ENTITY> ResultBuilder<BEAN, ENTITY> newInstance(List<BEAN> beans, ConditionSign<ENTITY, JoinConditionDescription> conditionSign, List<? extends FieldDescription<?, JoinConditionDescription>> fieldDescriptions, FillDataCallback fillDataCallback) {
        return new ResultBuilder<BEAN, ENTITY>(beans, conditionSign, fieldDescriptions, fillDataCallback);
    }

    public static interface FillDataCallback {
        default public String[] selectColumns(List<?> beans, ConditionSign<?, JoinConditionDescription> entityJoinCondition, List<? extends FieldDescription<?, JoinConditionDescription>> fieldAnnotationList) {
            return null;
        }

        default public void fillBefore(Object bean, FieldDescription<?, JoinConditionDescription> fieldAnnotation, List<?> entities) {
        }

        default public List<?> changeDataList(Object bean, FieldDescription<?, JoinConditionDescription> fieldAnnotation, List<?> entities) {
            return entities;
        }
    }
}

