/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.relevance.manager;

import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotationUtils;

public class EntityTableNameManager {
    public static final Map<Class<?>, String> ENTITY_TABLE_NAME_CACHE_MAP = new ConcurrentHashMap();

    public static <ENTITY> String getTableName(Class<ENTITY> entityClass) {
        return ENTITY_TABLE_NAME_CACHE_MAP.computeIfAbsent(entityClass, EntityTableNameManager::initTableName);
    }

    private static String initTableName(Class<?> entityClass) {
        TableName tableNameAnno = (TableName)AnnotationUtils.findAnnotation(entityClass, TableName.class);
        if (tableNameAnno != null) {
            return tableNameAnno.value();
        }
        return EntityTableNameManager.toSnakeCase(entityClass.getSimpleName());
    }

    private static String toSnakeCase(String camelCaseStr) {
        if (camelCaseStr.equals(camelCaseStr.toLowerCase())) {
            return camelCaseStr;
        }
        if (camelCaseStr.equals(camelCaseStr.toUpperCase())) {
            return camelCaseStr.toLowerCase();
        }
        char[] chars = camelCaseStr.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            if (Character.isUpperCase(c) && sb.length() > 0) {
                sb.append("_");
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }
}

