/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.relevance.metadata;

import com.tangzc.mpe.relevance.metadata.BindEntityByMidDescription;
import com.tangzc.mpe.relevance.metadata.BindEntityDescription;
import com.tangzc.mpe.relevance.metadata.BindFieldByMidDescription;
import com.tangzc.mpe.relevance.metadata.BindFieldDescription;
import com.tangzc.mpe.relevance.metadata.FieldDescription;
import com.tangzc.mpe.relevance.metadata.annotation.BindEntity;
import com.tangzc.mpe.relevance.metadata.annotation.BindEntityByMid;
import com.tangzc.mpe.relevance.metadata.annotation.BindField;
import com.tangzc.mpe.relevance.metadata.annotation.BindFieldByMid;
import com.tangzc.mpe.relevance.metadata.builder.FieldDescriptionBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class BeanDescription<BEAN> {
    private final Class<BEAN> beanClass;
    private final List<BindFieldDescription> bindFieldAnnotations = new ArrayList<BindFieldDescription>();
    private final List<BindEntityDescription> bindEntityAnnotations = new ArrayList<BindEntityDescription>();
    private final List<BindFieldByMidDescription> bindFieldByMidDescriptions = new ArrayList<BindFieldByMidDescription>();
    private final List<BindEntityByMidDescription> bindEntityByMidAnnotations = new ArrayList<BindEntityByMidDescription>();

    public BeanDescription(Class<BEAN> beanClass) {
        this.beanClass = beanClass;
    }

    public <BIND_ANNOTATION extends Annotation> void tryAddBindAnnotation(Field field, BIND_ANNOTATION annotation) {
        FieldDescription fieldDescription;
        if (annotation instanceof BindField) {
            BindFieldDescription fieldDescription2 = FieldDescriptionBuilder.build(this.beanClass, field, (BindField)annotation);
            this.bindFieldAnnotations.add(fieldDescription2);
            return;
        }
        if (annotation instanceof BindEntity) {
            fieldDescription = FieldDescriptionBuilder.build(this.beanClass, field, (BindEntity)annotation);
            this.bindEntityAnnotations.add((BindEntityDescription)fieldDescription);
        }
        if (annotation instanceof BindFieldByMid) {
            fieldDescription = FieldDescriptionBuilder.build(this.beanClass, field, (BindFieldByMid)annotation);
            this.bindFieldByMidDescriptions.add((BindFieldByMidDescription)fieldDescription);
        }
        if (annotation instanceof BindEntityByMid) {
            fieldDescription = FieldDescriptionBuilder.build(this.beanClass, field, (BindEntityByMid)annotation);
            this.bindEntityByMidAnnotations.add((BindEntityByMidDescription)fieldDescription);
        }
    }

    public boolean isValid() {
        return !this.bindFieldAnnotations.isEmpty() || !this.bindEntityAnnotations.isEmpty();
    }

    public Class<BEAN> getBeanClass() {
        return this.beanClass;
    }

    public List<BindFieldDescription> getBindFieldAnnotations() {
        return this.bindFieldAnnotations;
    }

    public List<BindEntityDescription> getBindEntityAnnotations() {
        return this.bindEntityAnnotations;
    }

    public List<BindFieldByMidDescription> getBindFieldByMidDescriptions() {
        return this.bindFieldByMidDescriptions;
    }

    public List<BindEntityByMidDescription> getBindEntityByMidAnnotations() {
        return this.bindEntityByMidAnnotations;
    }
}

