/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.util;

import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.springframework.beans.BeanUtils;

public class BeanClassUtil {
    public static <E> String getFieldName(SFunction<E, ?> sf) {
        LambdaMeta lambda = LambdaUtils.extract(sf);
        return PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
    }

    public static Map<String, Object> beanToMap(Object bean) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Class<?> beanClass = bean.getClass();
        List<Field> allDeclaredFields = BeanClassUtil.getAllDeclaredFields(beanClass);
        try {
            for (Field field : allDeclaredFields) {
                retMap.put(field.getName(), BeanClassUtil.getReadMethod(beanClass, field).invoke(bean, new Object[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retMap;
    }

    public static Class<?> getFieldRealClass(Field field) {
        Type genericType;
        Class fieldClass = field.getType();
        if (Collection.class.isAssignableFrom(fieldClass) && (genericType = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            fieldClass = (Class)pt.getActualTypeArguments()[0];
        }
        return fieldClass;
    }

    public static <T> Class<?> getFieldRealClass(Class<T> clazz, SFunction<T, ?> sFunction) {
        Type genericType;
        Field field;
        LambdaMeta lambda = LambdaUtils.extract(sFunction);
        String fieldName = PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
        try {
            field = clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(clazz + "\u4e0b\u672a\u627e\u5230" + fieldName + "\u5b57\u6bb5");
        }
        Class fieldClass = field.getType();
        if (Collection.class.isAssignableFrom(fieldClass) && (genericType = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            fieldClass = (Class)pt.getActualTypeArguments()[0];
        }
        return fieldClass;
    }

    public static Method getWriteMethod(Class<?> clazz, Field field) {
        field.setAccessible(true);
        String fieldName = field.getName();
        return BeanClassUtil.getWriteMethod(clazz, fieldName);
    }

    public static Method getWriteMethod(Class<?> clazz, String fieldName) {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(clazz, (String)fieldName);
        if (propertyDescriptor != null && propertyDescriptor.getWriteMethod() != null) {
            return propertyDescriptor.getWriteMethod();
        }
        throw new RuntimeException(clazz + "\u4e0b\u672a\u627e\u5230" + fieldName + "\u7684set\u65b9\u6cd5");
    }

    public static Method getReadMethod(Class<?> clazz, Field field) {
        field.setAccessible(true);
        String fieldName = field.getName();
        return BeanClassUtil.getReadMethod(clazz, fieldName);
    }

    public static Method getReadMethod(Class<?> clazz, String fieldName) {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(clazz, (String)fieldName);
        if (propertyDescriptor != null && propertyDescriptor.getReadMethod() != null) {
            return propertyDescriptor.getReadMethod();
        }
        throw new RuntimeException(clazz + "\u4e0b\u672a\u627e\u5230" + fieldName + "\u7684get/is\u65b9\u6cd5");
    }

    public static List<Field> getAllDeclaredFields(Class<?> beanClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        BeanClassUtil.getFieldList(fieldList, beanClass);
        return fieldList;
    }

    private static void getFieldList(List<Field> fields, Class<?> beanClass) {
        Field[] declaredFields = beanClass.getDeclaredFields();
        fields.addAll(Arrays.asList(declaredFields));
        Class<?> superclass = beanClass.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            BeanClassUtil.getFieldList(fields, superclass);
        }
    }
}

