/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.util;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtil.class);

    public static <ENTITY> Class<ENTITY> getEntityClass(BaseMapper<ENTITY> proxyMapper) {
        Class mapperClass = (Class)proxyMapper.getClass().getGenericInterfaces()[0];
        return ReflectionUtil.getEntityClass(mapperClass);
    }

    public static <ENTITY> Class<ENTITY> getEntityClass(Class<ENTITY> mapperClass) {
        try {
            String entityClassName;
            ParameterizedType genericType;
            Type[] superTypes;
            Type[] types = mapperClass.getGenericInterfaces();
            if (types.length > 0 && types[0] != null && (superTypes = (genericType = (ParameterizedType)types[0]).getActualTypeArguments()) != null && superTypes.length > 0 && superTypes[0] != null && (entityClassName = superTypes[0].getTypeName()).length() > 1) {
                return Class.forName(entityClassName);
            }
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790Mapper({})\u6cdb\u578b\u4e0a\u7684Entity\u51fa\u9519", mapperClass);
        }
        return null;
    }
}

