/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.util;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.schema.Table;
import org.springframework.core.annotation.AnnotationUtils;

public class TableColumnUtil {
    private static final Pattern LINE_PATTERN = Pattern.compile("_(\\w)");
    private static final Pattern HUMP_PATTERN = Pattern.compile("[A-Z]+");

    public static String getTableName(Table table) {
        return table.getName().replaceAll("`", "");
    }

    public static String getTableName(Class<?> entityClass) {
        TableName tableNameAnno = (TableName)AnnotationUtils.findAnnotation(entityClass, TableName.class);
        String tableName = tableNameAnno != null ? tableNameAnno.value() : TableColumnUtil.humpToLine(entityClass.getSimpleName());
        return tableName.replaceAll("`", "");
    }

    public static String getColumnName(Field field) {
        TableField annotation = (TableField)AnnotationUtils.findAnnotation((AnnotatedElement)field, TableField.class);
        String columnName = annotation != null && !annotation.value().isEmpty() ? annotation.value() : TableColumnUtil.humpToLine(field.getName());
        return columnName;
    }

    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = LINE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String humpToLine(String str) {
        Matcher matcher = HUMP_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

