/*
 * Decompiled with CFR 0.152.
 */
package importCsv;

import haxe.io.BytesOutput;
import haxe.io.Eof;
import haxe.io.Input;
import haxe.lang.DynamicObject;
import haxe.lang.EmptyObject;
import haxe.lang.Exceptions;
import haxe.lang.Function;
import haxe.lang.HaxeException;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import importCsv.CsvParser_Anon_215__Fun;
import importCsv.CsvParser_Anon_216__Fun;
import importCsv._CsvParser.CsvToken;
import importCsv._CsvParser.ISource;
import importCsv._CsvParser.InputSource;
import importCsv._CsvParser.StringSource;
import importCsv.error.UnexpectedCell;
import importCsv.error.UnexpectedEof;

public class CsvParser
extends HxObject {
    public static Function READ_CELL = CsvParser_Anon_215__Fun.__hx_current != null ? CsvParser_Anon_215__Fun.__hx_current : (CsvParser_Anon_215__Fun.__hx_current = new CsvParser_Anon_215__Fun());
    public static Function READ_COMMA = CsvParser_Anon_216__Fun.__hx_current != null ? CsvParser_Anon_216__Fun.__hx_current : (CsvParser_Anon_216__Fun.__hx_current = new CsvParser_Anon_216__Fun());

    public CsvParser(EmptyObject emptyObject) {
    }

    public CsvParser() {
        CsvParser.__hx_ctor_importCsv_CsvParser(this);
    }

    public static void __hx_ctor_importCsv_CsvParser(CsvParser csvParser) {
    }

    public static CsvToken nextToken(ISource iSource) {
        int n;
        int n2 = n = iSource.get_current();
        switch (n) {
            case -1: {
                return CsvToken.EOF;
            }
            case 44: {
                iSource.next();
                return CsvToken.COMMA;
            }
            case 10: {
                iSource.next();
                return CsvToken.CRLF;
            }
            case 13: {
                iSource.next();
                if (iSource.get_current() == 10) {
                    iSource.next();
                    return CsvToken.CRLF;
                }
                return CsvToken.CRLF;
            }
            case 34: {
                int n3 = iSource.get_position();
                BytesOutput bytesOutput = new BytesOutput();
                block14: while (true) {
                    int n4;
                    iSource.next();
                    int n5 = n4 = iSource.get_current();
                    switch (n4) {
                        case 34: {
                            iSource.next();
                            if (iSource.get_current() == 34) {
                                bytesOutput.writeByte(34);
                                continue block14;
                            }
                            return CsvToken.CELL(bytesOutput.getBytes().toString(), n3 + 1, iSource.get_position() - 1);
                        }
                        case -1: {
                            throw HaxeException.wrap(new UnexpectedEof(iSource.get_position(), iSource.get_position()));
                        }
                    }
                    bytesOutput.writeByte(n5);
                }
            }
        }
        int n6 = iSource.get_position();
        BytesOutput bytesOutput = new BytesOutput();
        bytesOutput.writeByte(n2);
        while (true) {
            int n7;
            iSource.next();
            int n8 = n7 = iSource.get_current();
            switch (n7) {
                case -1: 
                case 10: 
                case 13: 
                case 44: {
                    return CsvToken.CELL(bytesOutput.getBytes().toString(), n6, iSource.get_position());
                }
            }
            bytesOutput.writeByte(n8);
        }
    }

    public static Function readComma(ISource iSource, Array<Object> array) {
        CsvToken csvToken = CsvParser.nextToken(iSource);
        switch (csvToken.index) {
            case 1: 
            case 3: {
                return null;
            }
            case 0: {
                int n = Runtime.toInt(csvToken.params[2]);
                int n2 = Runtime.toInt(csvToken.params[1]);
                String string = Runtime.toString(csvToken.params[0]);
                throw HaxeException.wrap(new UnexpectedCell(n2, n));
            }
            case 2: {
                return READ_CELL;
            }
        }
        return null;
    }

    public static Function readCell(ISource iSource, Array<Object> array) {
        CsvToken csvToken = CsvParser.nextToken(iSource);
        switch (csvToken.index) {
            case 3: {
                DynamicObject dynamicObject = null;
                int n = iSource.get_position();
                int n2 = iSource.get_position();
                dynamicObject = new DynamicObject(new String[]{"content"}, new Object[]{""}, new String[]{"positionMax", "positionMin"}, new double[]{n2, n});
                array.push(dynamicObject);
                return null;
            }
            case 0: {
                int n = Runtime.toInt(csvToken.params[2]);
                int n3 = Runtime.toInt(csvToken.params[1]);
                String string = Runtime.toString(csvToken.params[0]);
                array.push(new DynamicObject(new String[]{"content"}, new Object[]{string}, new String[]{"positionMax", "positionMin"}, new double[]{n, n3}));
                return READ_COMMA;
            }
            case 2: {
                DynamicObject dynamicObject = null;
                int n = iSource.get_position();
                int n4 = iSource.get_position();
                dynamicObject = new DynamicObject(new String[]{"content"}, new Object[]{""}, new String[]{"positionMax", "positionMin"}, new double[]{n4, n});
                array.push(dynamicObject);
                return READ_CELL;
            }
            case 1: {
                DynamicObject dynamicObject = null;
                int n = iSource.get_position();
                int n5 = iSource.get_position();
                dynamicObject = new DynamicObject(new String[]{"content"}, new Object[]{""}, new String[]{"positionMax", "positionMin"}, new double[]{n5, n});
                array.push(dynamicObject);
                return null;
            }
        }
        return null;
    }

    public static Function readFirstCell(ISource iSource, Array<Object> array) {
        CsvToken csvToken = CsvParser.nextToken(iSource);
        switch (csvToken.index) {
            case 3: {
                throw HaxeException.wrap(new Eof());
            }
            case 0: {
                int n = Runtime.toInt(csvToken.params[2]);
                int n2 = Runtime.toInt(csvToken.params[1]);
                String string = Runtime.toString(csvToken.params[0]);
                array.push(new DynamicObject(new String[]{"content"}, new Object[]{string}, new String[]{"positionMax", "positionMin"}, new double[]{n, n2}));
                return READ_COMMA;
            }
            case 2: {
                DynamicObject dynamicObject = null;
                int n = iSource.get_position();
                int n3 = iSource.get_position();
                dynamicObject = new DynamicObject(new String[]{"content"}, new Object[]{""}, new String[]{"positionMax", "positionMin"}, new double[]{n3, n});
                array.push(dynamicObject);
                return READ_CELL;
            }
            case 1: {
                DynamicObject dynamicObject = null;
                int n = iSource.get_position();
                int n4 = iSource.get_position();
                dynamicObject = new DynamicObject(new String[]{"content"}, new Object[]{""}, new String[]{"positionMax", "positionMin"}, new double[]{n4, n});
                array.push(dynamicObject);
                return null;
            }
        }
        return null;
    }

    public static Array<Object> parseRow(ISource iSource) {
        Array<Object> array = new Array<Object>(new Object[0]);
        for (Function function = CsvParser.readFirstCell(iSource, array); function != null; function = (Function)function.__hx_invoke2_o(0.0, iSource, 0.0, array)) {
        }
        return array;
    }

    public static Array<Array<Object>> parse(ISource iSource) {
        Array<Array<Object>> array = new Array<Array<Object>>(new Array[0]);
        while (true) {
            Array<Object> array2 = null;
            try {
                array2 = CsvParser.parseRow(iSource);
            }
            catch (Throwable throwable) {
                Exceptions.setException(throwable);
                Object object = throwable;
                if (object instanceof HaxeException) {
                    object = ((HaxeException)throwable).obj;
                }
                if (object instanceof Eof) {
                    Eof eof = (Eof)object;
                    return array;
                }
                throw HaxeException.wrap(throwable);
            }
            array.push(array2);
        }
    }

    public static Array<Array<Object>> parseString(String string) {
        return CsvParser.parse(new StringSource(Runtime.toString(string)));
    }

    public static Array<Array<Object>> parseInput(Input input) {
        return CsvParser.parse(new InputSource(input));
    }

    public static Object __hx_createEmpty() {
        return new CsvParser(EmptyObject.EMPTY);
    }

    public static Object __hx_create(Array array) {
        return new CsvParser();
    }
}

