/*
 * Decompiled with CFR 0.152.
 */
package haxe;

import haxe.StackItem;
import haxe.lang.EmptyObject;
import haxe.lang.Exceptions;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import haxe.root.StringBuf;

public class CallStack
extends HxObject {
    public CallStack(EmptyObject emptyObject) {
    }

    public CallStack() {
        CallStack.__hx_ctor_haxe_CallStack(this);
    }

    public static void __hx_ctor_haxe_CallStack(CallStack callStack) {
    }

    public static Array<StackItem> callStack() {
        Array<StackItem> array = new Array<StackItem>(new StackItem[0]);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string = stackTraceElement.getClassName();
            String string2 = stackTraceElement.getMethodName();
            String string3 = stackTraceElement.getFileName();
            int n = stackTraceElement.getLineNumber();
            StackItem stackItem = StackItem.Method(string, string2);
            if (string3 != null || n >= 0) {
                array.push(StackItem.FilePos(stackItem, string3, n));
                continue;
            }
            array.push(stackItem);
        }
        array.shift();
        array.shift();
        array.pop();
        return array;
    }

    public static Array<StackItem> exceptionStack() {
        Array<StackItem> array = new Array<StackItem>(new StackItem[0]);
        StackTraceElement[] stackTraceElementArray = Exceptions.currentException().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string = stackTraceElement.getClassName();
            String string2 = stackTraceElement.getMethodName();
            String string3 = stackTraceElement.getFileName();
            int n = stackTraceElement.getLineNumber();
            StackItem stackItem = StackItem.Method(string, string2);
            if (string3 != null || n >= 0) {
                array.push(StackItem.FilePos(stackItem, string3, n));
                continue;
            }
            array.push(stackItem);
        }
        array.shift();
        array.pop();
        return array;
    }

    public static String toString(Array<StackItem> array) {
        StringBuf stringBuf = new StringBuf();
        for (int i = 0; i < array.length; ++i) {
            StackItem stackItem = array.__get(i);
            stringBuf.add("\nCalled from ");
            CallStack.itemToString(stringBuf, stackItem);
        }
        return stringBuf.toString();
    }

    public static void itemToString(StringBuf stringBuf, StackItem stackItem) {
        switch (stackItem.index) {
            case 0: {
                stringBuf.add("a C function");
                break;
            }
            case 1: {
                String string = Runtime.toString(stackItem.params[0]);
                stringBuf.add("module ");
                stringBuf.add(string);
                break;
            }
            case 2: {
                int n = Runtime.toInt(stackItem.params[2]);
                String string = Runtime.toString(stackItem.params[1]);
                StackItem stackItem2 = (StackItem)stackItem.params[0];
                if (stackItem2 != null) {
                    CallStack.itemToString(stringBuf, stackItem2);
                    stringBuf.add(" (");
                }
                stringBuf.add(string);
                stringBuf.add(" line ");
                stringBuf.add(n);
                if (stackItem2 == null) break;
                stringBuf.add(")");
                break;
            }
            case 3: {
                String string = Runtime.toString(stackItem.params[1]);
                String string2 = Runtime.toString(stackItem.params[0]);
                stringBuf.add(string2);
                stringBuf.add(".");
                stringBuf.add(string);
                break;
            }
            case 4: {
                Object object = stackItem.params[0];
                stringBuf.add("local function #");
                stringBuf.add(object);
                break;
            }
        }
    }

    public static Object makeStack(Object object) {
        return null;
    }

    public static Object __hx_createEmpty() {
        return new CallStack(EmptyObject.EMPTY);
    }

    public static Object __hx_create(Array array) {
        return new CallStack();
    }
}

