/*
 * Decompiled with CFR 0.152.
 */
package haxe.io;

import haxe.io.Bytes;
import haxe.io.Eof;
import haxe.io.Error;
import haxe.io.FPHelper;
import haxe.io.Input;
import haxe.lang.Closure;
import haxe.lang.EmptyObject;
import haxe.lang.Exceptions;
import haxe.lang.HaxeException;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import java.nio.ByteBuffer;

public class Output
extends HxObject {
    public boolean bigEndian;
    public ByteBuffer helper;

    public Output(EmptyObject emptyObject) {
    }

    public Output() {
        Output.__hx_ctor_haxe_io_Output(this);
    }

    public static void __hx_ctor_haxe_io_Output(Output output) {
    }

    public static Object __hx_createEmpty() {
        return new Output(EmptyObject.EMPTY);
    }

    public static Object __hx_create(Array array) {
        return new Output();
    }

    public void writeByte(int n) {
        throw HaxeException.wrap("Not implemented");
    }

    public int writeBytes(Bytes bytes, int n, int n2) {
        byte[] byArray = bytes.b;
        if (n < 0 || n2 < 0 || n + n2 > bytes.length) {
            throw HaxeException.wrap(Error.OutsideBounds);
        }
        for (int i = n2; i > 0; --i) {
            this.writeByte(byArray[n]);
            ++n;
        }
        return n2;
    }

    public void flush() {
    }

    public void close() {
    }

    public boolean set_bigEndian(boolean bl) {
        this.bigEndian = bl;
        return bl;
    }

    public void write(Bytes bytes) {
        int n;
        int n2 = 0;
        for (int i = bytes.length; i > 0; i -= n) {
            n = this.writeBytes(bytes, n2, i);
            if (n == 0) {
                throw HaxeException.wrap(Error.Blocked);
            }
            n2 += n;
        }
    }

    public void writeFullBytes(Bytes bytes, int n, int n2) {
        while (n2 > 0) {
            int n3 = this.writeBytes(bytes, n, n2);
            n += n3;
            n2 -= n3;
        }
    }

    public final void writeFloat(double d) {
        this.writeInt32(FPHelper.floatToI32(d));
    }

    public void writeDouble(double d) {
        long l = FPHelper.doubleToI64(d);
        if (this.bigEndian) {
            this.writeInt32(Runtime.toInt(l >> 32));
            this.writeInt32(Runtime.toInt(l));
        } else {
            this.writeInt32(Runtime.toInt(l));
            this.writeInt32(Runtime.toInt(l >> 32));
        }
    }

    public void writeInt8(int n) {
        if (n < -128 || n >= 128) {
            throw HaxeException.wrap(Error.Overflow);
        }
        this.writeByte(n & 0xFF);
    }

    public void writeInt16(int n) {
        if (n < Short.MIN_VALUE || n >= 32768) {
            throw HaxeException.wrap(Error.Overflow);
        }
        this.writeUInt16(n & 0xFFFF);
    }

    public void writeUInt16(int n) {
        if (n < 0 || n >= 65536) {
            throw HaxeException.wrap(Error.Overflow);
        }
        if (this.bigEndian) {
            this.writeByte(n >> 8);
            this.writeByte(n & 0xFF);
        } else {
            this.writeByte(n & 0xFF);
            this.writeByte(n >> 8);
        }
    }

    public void writeInt24(int n) {
        if (n < -8388608 || n >= 0x800000) {
            throw HaxeException.wrap(Error.Overflow);
        }
        this.writeUInt24(n & 0xFFFFFF);
    }

    public void writeUInt24(int n) {
        if (n < 0 || n >= 0x1000000) {
            throw HaxeException.wrap(Error.Overflow);
        }
        if (this.bigEndian) {
            this.writeByte(n >> 16);
            this.writeByte(n >> 8 & 0xFF);
            this.writeByte(n & 0xFF);
        } else {
            this.writeByte(n & 0xFF);
            this.writeByte(n >> 8 & 0xFF);
            this.writeByte(n >> 16);
        }
    }

    public void writeInt32(int n) {
        if (this.bigEndian) {
            this.writeByte(n >>> 24);
            this.writeByte(n >> 16 & 0xFF);
            this.writeByte(n >> 8 & 0xFF);
            this.writeByte(n & 0xFF);
        } else {
            this.writeByte(n & 0xFF);
            this.writeByte(n >> 8 & 0xFF);
            this.writeByte(n >> 16 & 0xFF);
            this.writeByte(n >>> 24);
        }
    }

    public void prepare(int n) {
    }

    public void writeInput(Input input, Object object) {
        if (Runtime.eq(object, null)) {
            object = 4096;
        }
        Bytes bytes = Bytes.alloc(Runtime.toInt(object));
        try {
            block2: while (true) {
                int n;
                if ((n = input.readBytes(bytes, 0, Runtime.toInt(object))) == 0) {
                    throw HaxeException.wrap(Error.Blocked);
                }
                int n2 = 0;
                while (true) {
                    if (n <= 0) continue block2;
                    int n3 = this.writeBytes(bytes, n2, n);
                    if (n3 == 0) {
                        throw HaxeException.wrap(Error.Blocked);
                    }
                    n2 += n3;
                    n -= n3;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Exceptions.setException(throwable);
            Object object2 = throwable;
            if (object2 instanceof HaxeException) {
                object2 = ((HaxeException)throwable).obj;
            }
            if (!(object2 instanceof Eof)) {
                throw HaxeException.wrap(throwable);
            }
            Eof eof = (Eof)object2;
            return;
        }
    }

    public void writeString(String string) {
        Bytes bytes = Bytes.ofString(string);
        this.writeFullBytes(bytes, 0, bytes.length);
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        switch (string.hashCode()) {
            case -1220931666: {
                if (!string.equals("helper")) break;
                bl2 = false;
                this.helper = (ByteBuffer)object;
                return object;
            }
            case 0x222B44BB: {
                if (!string.equals("bigEndian")) break;
                bl2 = false;
                if (bl) {
                    this.set_bigEndian(Runtime.toBool(object));
                    return object;
                }
                this.bigEndian = Runtime.toBool(object);
                return object;
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        switch (string.hashCode()) {
            case 1412235472: {
                if (!string.equals("writeString")) break;
                bl4 = false;
                return new Closure(this, "writeString");
            }
            case 0x222B44BB: {
                if (!string.equals("bigEndian")) break;
                bl4 = false;
                return this.bigEndian;
            }
            case -656596181: {
                if (!string.equals("writeInput")) break;
                bl4 = false;
                return new Closure(this, "writeInput");
            }
            case -1220931666: {
                if (!string.equals("helper")) break;
                bl4 = false;
                return this.helper;
            }
            case -318370553: {
                if (!string.equals("prepare")) break;
                bl4 = false;
                return new Closure(this, "prepare");
            }
            case -1406851705: {
                if (!string.equals("writeByte")) break;
                bl4 = false;
                return new Closure(this, "writeByte");
            }
            case -656594449: {
                if (!string.equals("writeInt32")) break;
                bl4 = false;
                return new Closure(this, "writeInt32");
            }
            case -662729780: {
                if (!string.equals("writeBytes")) break;
                bl4 = false;
                return new Closure(this, "writeBytes");
            }
            case 1429671867: {
                if (!string.equals("writeUInt24")) break;
                bl4 = false;
                return new Closure(this, "writeUInt24");
            }
            case 97532676: {
                if (!string.equals("flush")) break;
                bl4 = false;
                return new Closure(this, "flush");
            }
            case -656594478: {
                if (!string.equals("writeInt24")) break;
                bl4 = false;
                return new Closure(this, "writeInt24");
            }
            case 94756344: {
                if (!string.equals("close")) break;
                bl4 = false;
                return new Closure(this, "close");
            }
            case 1429671838: {
                if (!string.equals("writeUInt16")) break;
                bl4 = false;
                return new Closure(this, "writeUInt16");
            }
            case 1862232350: {
                if (!string.equals("set_bigEndian")) break;
                bl4 = false;
                return new Closure(this, "set_bigEndian");
            }
            case -656594507: {
                if (!string.equals("writeInt16")) break;
                bl4 = false;
                return new Closure(this, "writeInt16");
            }
            case 113399775: {
                if (!string.equals("write")) break;
                bl4 = false;
                return new Closure(this, "write");
            }
            case -1406653784: {
                if (!string.equals("writeInt8")) break;
                bl4 = false;
                return new Closure(this, "writeInt8");
            }
            case 1188045309: {
                if (!string.equals("writeFullBytes")) break;
                bl4 = false;
                return new Closure(this, "writeFullBytes");
            }
            case 978263184: {
                if (!string.equals("writeDouble")) break;
                bl4 = false;
                return new Closure(this, "writeDouble");
            }
            case -659427907: {
                if (!string.equals("writeFloat")) break;
                bl4 = false;
                return new Closure(this, "writeFloat");
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Array array) {
        boolean bl = true;
        switch (string.hashCode()) {
            case 1412235472: {
                if (!string.equals("writeString")) break;
                bl = false;
                this.writeString(Runtime.toString(array.__get(0)));
                break;
            }
            case -1406851705: {
                if (!string.equals("writeByte")) break;
                bl = false;
                this.writeByte(Runtime.toInt(array.__get(0)));
                break;
            }
            case -656596181: {
                if (!string.equals("writeInput")) break;
                bl = false;
                this.writeInput((Input)array.__get(0), array.__get(1));
                break;
            }
            case -662729780: {
                if (!string.equals("writeBytes")) break;
                bl = false;
                return this.writeBytes((Bytes)array.__get(0), Runtime.toInt(array.__get(1)), Runtime.toInt(array.__get(2)));
            }
            case -318370553: {
                if (!string.equals("prepare")) break;
                bl = false;
                this.prepare(Runtime.toInt(array.__get(0)));
                break;
            }
            case 97532676: {
                if (!string.equals("flush")) break;
                bl = false;
                this.flush();
                break;
            }
            case -656594449: {
                if (!string.equals("writeInt32")) break;
                bl = false;
                this.writeInt32(Runtime.toInt(array.__get(0)));
                break;
            }
            case 94756344: {
                if (!string.equals("close")) break;
                bl = false;
                this.close();
                break;
            }
            case 1429671867: {
                if (!string.equals("writeUInt24")) break;
                bl = false;
                this.writeUInt24(Runtime.toInt(array.__get(0)));
                break;
            }
            case 1862232350: {
                if (!string.equals("set_bigEndian")) break;
                bl = false;
                return this.set_bigEndian(Runtime.toBool(array.__get(0)));
            }
            case -656594478: {
                if (!string.equals("writeInt24")) break;
                bl = false;
                this.writeInt24(Runtime.toInt(array.__get(0)));
                break;
            }
            case 113399775: {
                if (!string.equals("write")) break;
                bl = false;
                this.write((Bytes)array.__get(0));
                break;
            }
            case 1429671838: {
                if (!string.equals("writeUInt16")) break;
                bl = false;
                this.writeUInt16(Runtime.toInt(array.__get(0)));
                break;
            }
            case 1188045309: {
                if (!string.equals("writeFullBytes")) break;
                bl = false;
                this.writeFullBytes((Bytes)array.__get(0), Runtime.toInt(array.__get(1)), Runtime.toInt(array.__get(2)));
                break;
            }
            case -656594507: {
                if (!string.equals("writeInt16")) break;
                bl = false;
                this.writeInt16(Runtime.toInt(array.__get(0)));
                break;
            }
            case -659427907: {
                if (!string.equals("writeFloat")) break;
                bl = false;
                this.writeFloat(Runtime.toDouble(array.__get(0)));
                break;
            }
            case -1406653784: {
                if (!string.equals("writeInt8")) break;
                bl = false;
                this.writeInt8(Runtime.toInt(array.__get(0)));
                break;
            }
            case 978263184: {
                if (!string.equals("writeDouble")) break;
                bl = false;
                this.writeDouble(Runtime.toDouble(array.__get(0)));
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, array);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("helper");
        array.push("bigEndian");
        super.__hx_getFields(array);
    }
}

