/*
 * Decompiled with CFR 0.152.
 */
package haxe.root;

import haxe.lang.EmptyObject;
import haxe.lang.Exceptions;
import haxe.lang.HaxeException;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.lang.StringExt;
import haxe.root.Array;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class StringTools
extends HxObject {
    public StringTools(EmptyObject emptyObject) {
    }

    public StringTools() {
        StringTools.__hx_ctor__StringTools(this);
    }

    public static void __hx_ctor__StringTools(StringTools stringTools) {
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Throwable throwable) {
            Exceptions.setException(throwable);
            Object object = throwable;
            if (object instanceof HaxeException) {
                object = ((HaxeException)throwable).obj;
            }
            Throwable throwable2 = object;
            throw HaxeException.wrap(throwable2);
        }
    }

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (Throwable throwable) {
            Exceptions.setException(throwable);
            Object object = throwable;
            if (object instanceof HaxeException) {
                object = ((HaxeException)throwable).obj;
            }
            Throwable throwable2 = object;
            throw HaxeException.wrap(throwable2);
        }
    }

    public static String htmlEscape(String string, Object object) {
        string = StringExt.split(StringExt.split(StringExt.split(string, "&").join("&amp;"), "<").join("&lt;"), ">").join("&gt;");
        if (Runtime.toBool(object)) {
            return StringExt.split(StringExt.split(string, "\"").join("&quot;"), "'").join("&#039;");
        }
        return string;
    }

    public static String htmlUnescape(String string) {
        return StringExt.split(StringExt.split(StringExt.split(StringExt.split(StringExt.split(string, "&gt;").join(">"), "&lt;").join("<"), "&quot;").join("\""), "&#039;").join("'"), "&amp;").join("&");
    }

    public static boolean startsWith(String string, String string2) {
        return string.startsWith(string2);
    }

    public static boolean endsWith(String string, String string2) {
        return string.endsWith(string2);
    }

    public static boolean isSpace(String string, int n) {
        Object object = StringExt.charCodeAt(string, n);
        return Runtime.compare(object, 8) > 0 && Runtime.compare(object, 14) < 0 || Runtime.eq(object, 32);
    }

    public static String ltrim(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && StringTools.isSpace(string, n); ++n) {
        }
        if (n > 0) {
            return StringExt.substr(string, n, n2 - n);
        }
        return string;
    }

    public static String rtrim(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && StringTools.isSpace(string, n2 - n - 1); ++n) {
        }
        if (n > 0) {
            return StringExt.substr(string, 0, n2 - n);
        }
        return string;
    }

    public static String trim(String string) {
        return string.trim();
    }

    public static String lpad(String string, String string2, int n) {
        if (string2.length() <= 0) {
            return string;
        }
        while (string.length() < n) {
            string = string2 + string;
        }
        return string;
    }

    public static String rpad(String string, String string2, int n) {
        if (string2.length() <= 0) {
            return string;
        }
        while (string.length() < n) {
            string = string + string2;
        }
        return string;
    }

    public static String replace(String string, String string2, String string3) {
        if (string2.length() == 0) {
            return StringExt.split(string, string2).join(string3);
        }
        return string.replace(string2, string3);
    }

    public static String hex(int n, Object object) {
        String string = "";
        String string2 = "0123456789ABCDEF";
        do {
            string = StringExt.charAt(string2, n & 0xF) + string;
        } while ((n >>>= 4) > 0);
        if (!Runtime.eq(object, null)) {
            while (Runtime.compare(string.length(), object) < 0) {
                string = "0" + string;
            }
        }
        return string;
    }

    public static int fastCodeAt(String string, int n) {
        if (n < string.length()) {
            return string.charAt(n);
        }
        return -1;
    }

    public static boolean isEof(int n) {
        return n == -1;
    }

    public static char _charAt(String string, int n) {
        return string.charAt(n);
    }

    public static Object __hx_createEmpty() {
        return new StringTools(EmptyObject.EMPTY);
    }

    public static Object __hx_create(Array array) {
        return new StringTools();
    }
}

