/*
 * Decompiled with CFR 0.152.
 */
package jsonStream.io;

import com.dongxiguo.continuation.utils.Generator;
import haxe.io.BytesBuffer;
import haxe.lang.EmptyObject;
import haxe.lang.HaxeException;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import jsonStream.JsonStream;
import jsonStream.io.BsonReaderError;
import jsonStream.io.BsonReader_readBsonStream_194__Fun;
import jsonStream.io.BsonReader_readBsonValue_79__Fun;
import reactivemongo.bson.buffer.ReadableBuffer;

public class BsonReader
extends HxObject {
    public static Array<Object> EXCEPT_BSON_TYPE_CODE = new Array<Object>(new Object[]{1, 2, 3, 4, 5, 7, 8, 10, 16, 18});

    public BsonReader(EmptyObject emptyObject) {
    }

    public BsonReader() {
        BsonReader.__hx_ctor_jsonStream_io_BsonReader(this);
    }

    public static void __hx_ctor_jsonStream_io_BsonReader(BsonReader bsonReader) {
    }

    public static JsonStream readBsonValue(ReadableBuffer readableBuffer, int n) {
        try {
            switch (n) {
                case 1: {
                    return JsonStream.NUMBER(readableBuffer.readDouble());
                }
                case 2: {
                    return JsonStream.STRING(readableBuffer.readString());
                }
                case 3: {
                    return BsonReader.readBsonStream(readableBuffer);
                }
                case 4: {
                    return JsonStream.ARRAY(new Generator(new BsonReader_readBsonValue_79__Fun(readableBuffer)));
                }
                case 5: {
                    int n2 = readableBuffer.readInt();
                    int n3 = 0;
                    Object object = null;
                    Byte by = null;
                    int n4 = readableBuffer.readByte();
                    by = (byte)n4;
                    object = by;
                    n3 = ((Byte)object).intValue();
                    if (n3 != 0) {
                        throw HaxeException.wrap(BsonReaderError.EXCEPT_BINARY_TYPECODE(n3, 0));
                    }
                    object = new BytesBuffer();
                    int n5 = -1;
                    while (++n5 < n2) {
                        n4 = 0;
                        Byte by2 = null;
                        Byte by3 = null;
                        byte by4 = readableBuffer.readByte();
                        by2 = by3 = Byte.valueOf(by4);
                        n4 = by2.intValue();
                        ((BytesBuffer)object).b.write(n4);
                    }
                    return JsonStream.BINARY(((BytesBuffer)object).getBytes());
                }
                case 6: {
                    throw HaxeException.wrap(BsonReaderError.UNSUPPORT_BSON_TYPE(6, EXCEPT_BSON_TYPE_CODE));
                }
                case 7: {
                    int n6 = -1;
                    while (++n6 < 12) {
                        Byte by = null;
                        Byte by5 = null;
                        byte by6 = readableBuffer.readByte();
                        by = by5 = Byte.valueOf(by6);
                        by.intValue();
                    }
                    return JsonStream.NULL;
                }
                case 8: {
                    int n7 = 0;
                    Byte by = null;
                    Byte by7 = null;
                    byte by8 = readableBuffer.readByte();
                    by = by7 = Byte.valueOf(by8);
                    n7 = by.intValue();
                    if (n7 == 1) {
                        return JsonStream.TRUE;
                    }
                    return JsonStream.FALSE;
                }
                case 9: {
                    throw HaxeException.wrap(BsonReaderError.UNSUPPORT_BSON_TYPE(9, EXCEPT_BSON_TYPE_CODE));
                }
                case 10: {
                    return JsonStream.NULL;
                }
                case 11: {
                    throw HaxeException.wrap(BsonReaderError.UNSUPPORT_BSON_TYPE(11, EXCEPT_BSON_TYPE_CODE));
                }
                case 12: {
                    throw HaxeException.wrap(BsonReaderError.UNSUPPORT_BSON_TYPE(12, EXCEPT_BSON_TYPE_CODE));
                }
                case 13: {
                    throw HaxeException.wrap(BsonReaderError.UNSUPPORT_BSON_TYPE(13, EXCEPT_BSON_TYPE_CODE));
                }
                case 14: {
                    throw HaxeException.wrap(BsonReaderError.UNSUPPORT_BSON_TYPE(14, EXCEPT_BSON_TYPE_CODE));
                }
                case 15: {
                    throw HaxeException.wrap(BsonReaderError.UNSUPPORT_BSON_TYPE(15, EXCEPT_BSON_TYPE_CODE));
                }
                case 16: {
                    return JsonStream.INT32(readableBuffer.readInt());
                }
                case 17: {
                    throw HaxeException.wrap(BsonReaderError.UNSUPPORT_BSON_TYPE(17, EXCEPT_BSON_TYPE_CODE));
                }
                case 18: {
                    long l = readableBuffer.readLong();
                    return JsonStream.INT64(Runtime.toInt(l >> 32), Runtime.toInt(l));
                }
                case 255: {
                    throw HaxeException.wrap(BsonReaderError.UNSUPPORT_BSON_TYPE(255, EXCEPT_BSON_TYPE_CODE));
                }
                case 127: {
                    throw HaxeException.wrap(BsonReaderError.UNSUPPORT_BSON_TYPE(127, EXCEPT_BSON_TYPE_CODE));
                }
            }
            String string = Byte.toString((byte)n);
            throw HaxeException.wrap(BsonReaderError.UNMATCHED_BSON_TYPE(readableBuffer, EXCEPT_BSON_TYPE_CODE));
        }
        catch (Throwable throwable) {
            throw HaxeException.wrap(throwable);
        }
    }

    public static JsonStream readBsonStream(ReadableBuffer readableBuffer) {
        return JsonStream.OBJECT(new Generator(new BsonReader_readBsonStream_194__Fun(readableBuffer)));
    }

    public static Object __hx_createEmpty() {
        return new BsonReader(EmptyObject.EMPTY);
    }

    public static Object __hx_create(Array array) {
        return new BsonReader();
    }
}

