/*
 * Decompiled with CFR 0.152.
 */
package haxe.crypto;

import haxe.io.Bytes;
import haxe.lang.Closure;
import haxe.lang.EmptyObject;
import haxe.lang.HaxeException;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;

public class BaseCode
extends HxObject {
    public Bytes base;
    public int nbits;
    public Array<Object> tbl;

    public BaseCode(EmptyObject emptyObject) {
    }

    public BaseCode(Bytes bytes) {
        BaseCode.__hx_ctor_haxe_crypto_BaseCode(this, bytes);
    }

    public static void __hx_ctor_haxe_crypto_BaseCode(BaseCode baseCode, Bytes bytes) {
        int n = bytes.length;
        int n2 = 1;
        while (n > 1 << n2) {
            ++n2;
        }
        if (n2 > 8 || n != 1 << n2) {
            throw HaxeException.wrap("BaseCode : base length must be a power of two.");
        }
        baseCode.base = bytes;
        baseCode.nbits = n2;
    }

    public static String encode(String string, String string2) {
        BaseCode baseCode = new BaseCode(Bytes.ofString(string2));
        return baseCode.encodeString(string);
    }

    public static String decode(String string, String string2) {
        BaseCode baseCode = new BaseCode(Bytes.ofString(string2));
        return baseCode.decodeString(string);
    }

    public static Object __hx_createEmpty() {
        return new BaseCode(EmptyObject.EMPTY);
    }

    public static Object __hx_create(Array array) {
        return new BaseCode((Bytes)array.__get(0));
    }

    public Bytes encodeBytes(Bytes bytes) {
        int n;
        int n2 = this.nbits;
        Bytes bytes2 = this.base;
        int n3 = bytes.length * 8 / n2;
        Bytes bytes3 = Bytes.alloc(n3 + (bytes.length * 8 % n2 == 0 ? 0 : 1));
        int n4 = 0;
        int n5 = 0;
        int n6 = (1 << n2) - 1;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n3) {
            while (n5 < n2) {
                n5 += 8;
                n4 <<= 8;
                n = n7++;
                n4 |= bytes.b[n] & 0xFF;
            }
            n = n8++;
            bytes3.b[n] = (byte)(bytes2.b[n4 >> (n5 -= n2) & n6] & 0xFF);
        }
        if (n5 > 0) {
            n = n8++;
            bytes3.b[n] = (byte)(bytes2.b[n4 << n2 - n5 & n6] & 0xFF);
        }
        return bytes3;
    }

    public void initTable() {
        int n;
        Array<Integer> array = new Array<Integer>();
        int n2 = 0;
        while (n2 < 256) {
            n = n2++;
            array.__set(n, -1);
        }
        n2 = 0;
        n = this.base.length;
        while (n2 < n) {
            int n3 = n2++;
            array.__set(this.base.b[n3] & 0xFF, n3);
        }
        this.tbl = array;
    }

    public Bytes decodeBytes(Bytes bytes) {
        int n = this.nbits;
        Bytes bytes2 = this.base;
        if (this.tbl == null) {
            this.initTable();
        }
        Array<Object> array = this.tbl;
        int n2 = bytes.length * n >> 3;
        Bytes bytes3 = Bytes.alloc(n2);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            while (n4 < 8) {
                int n8;
                Object object;
                int n9;
                n4 += n;
                n3 <<= n;
                n7 = 0;
                if ((n9 = Runtime.toInt(object = array.__get(n7 = bytes.b[n8 = n5++] & 0xFF))) == -1) {
                    throw HaxeException.wrap("BaseCode : invalid encoded char");
                }
                n3 |= n9;
            }
            n7 = n6++;
            bytes3.b[n7] = (byte)(n3 >> (n4 -= 8) & 0xFF);
        }
        return bytes3;
    }

    public String encodeString(String string) {
        return this.encodeBytes(Bytes.ofString(string)).toString();
    }

    public String decodeString(String string) {
        return this.decodeBytes(Bytes.ofString(string)).toString();
    }

    @Override
    public double __hx_setField_f(String string, double d, boolean bl) {
        boolean bl2 = true;
        switch (string.hashCode()) {
            case 104611444: {
                if (!string.equals("nbits")) break;
                bl2 = false;
                this.nbits = (int)d;
                return d;
            }
        }
        if (bl2) {
            return super.__hx_setField_f(string, d, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        switch (string.hashCode()) {
            case 114622: {
                if (!string.equals("tbl")) break;
                bl2 = false;
                this.tbl = (Array)object;
                return object;
            }
            case 3016401: {
                if (!string.equals("base")) break;
                bl2 = false;
                this.base = (Bytes)object;
                return object;
            }
            case 104611444: {
                if (!string.equals("nbits")) break;
                bl2 = false;
                this.nbits = Runtime.toInt(object);
                return object;
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        switch (string.hashCode()) {
            case -2001259617: {
                if (!string.equals("decodeString")) break;
                bl4 = false;
                return new Closure(this, "decodeString");
            }
            case 3016401: {
                if (!string.equals("base")) break;
                bl4 = false;
                return this.base;
            }
            case -864869945: {
                if (!string.equals("encodeString")) break;
                bl4 = false;
                return new Closure(this, "encodeString");
            }
            case 104611444: {
                if (!string.equals("nbits")) break;
                bl4 = false;
                return this.nbits;
            }
            case 1166820125: {
                if (!string.equals("decodeBytes")) break;
                bl4 = false;
                return new Closure(this, "decodeBytes");
            }
            case 114622: {
                if (!string.equals("tbl")) break;
                bl4 = false;
                return this.tbl;
            }
            case -268398434: {
                if (!string.equals("initTable")) break;
                bl4 = false;
                return new Closure(this, "initTable");
            }
            case 1896214517: {
                if (!string.equals("encodeBytes")) break;
                bl4 = false;
                return new Closure(this, "encodeBytes");
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public double __hx_getField_f(String string, boolean bl, boolean bl2) {
        boolean bl3 = true;
        switch (string.hashCode()) {
            case 104611444: {
                if (!string.equals("nbits")) break;
                bl3 = false;
                return this.nbits;
            }
        }
        if (bl3) {
            return super.__hx_getField_f(string, bl, bl2);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Array array) {
        boolean bl = true;
        switch (string.hashCode()) {
            case -2001259617: {
                if (!string.equals("decodeString")) break;
                bl = false;
                return this.decodeString(Runtime.toString(array.__get(0)));
            }
            case 1896214517: {
                if (!string.equals("encodeBytes")) break;
                bl = false;
                return this.encodeBytes((Bytes)array.__get(0));
            }
            case -864869945: {
                if (!string.equals("encodeString")) break;
                bl = false;
                return this.encodeString(Runtime.toString(array.__get(0)));
            }
            case -268398434: {
                if (!string.equals("initTable")) break;
                bl = false;
                this.initTable();
                break;
            }
            case 1166820125: {
                if (!string.equals("decodeBytes")) break;
                bl = false;
                return this.decodeBytes((Bytes)array.__get(0));
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, array);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("tbl");
        array.push("nbits");
        array.push("base");
        super.__hx_getFields(array);
    }
}

