/*
 * Decompiled with CFR 0.152.
 */
package haxe.ds;

import _Array.ArrayIterator;
import haxe.ds.TreeNode;
import haxe.lang.Closure;
import haxe.lang.EmptyObject;
import haxe.lang.Exceptions;
import haxe.lang.HaxeException;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import haxe.root.Reflect;

public class BalancedTree<K, V>
extends HxObject {
    public TreeNode<K, V> root;

    public BalancedTree(EmptyObject emptyObject) {
    }

    public BalancedTree() {
        BalancedTree.__hx_ctor_haxe_ds_BalancedTree(this);
    }

    public static <K_c, V_c> void __hx_ctor_haxe_ds_BalancedTree(BalancedTree<K_c, V_c> balancedTree) {
    }

    public static Object __hx_createEmpty() {
        return new BalancedTree(EmptyObject.EMPTY);
    }

    public static Object __hx_create(Array array) {
        return new BalancedTree();
    }

    public void set(K k, V v) {
        this.root = this.setLoop(k, v, this.root);
    }

    public Object get(K k) {
        TreeNode<K, V> treeNode = this.root;
        while (treeNode != null) {
            int n = this.compare(k, treeNode.key);
            if (n == 0) {
                return treeNode.value;
            }
            if (n < 0) {
                treeNode = treeNode.left;
                continue;
            }
            treeNode = treeNode.right;
        }
        return null;
    }

    public boolean remove(K k) {
        try {
            this.root = this.removeLoop(k, this.root);
            return true;
        }
        catch (Throwable throwable) {
            Exceptions.setException(throwable);
            Object object = throwable;
            if (object instanceof HaxeException) {
                object = ((HaxeException)throwable).obj;
            }
            if (object instanceof String) {
                String string = Runtime.toString(object);
                return false;
            }
            throw HaxeException.wrap(throwable);
        }
    }

    public boolean exists(K k) {
        TreeNode<K, V> treeNode = this.root;
        while (treeNode != null) {
            int n = this.compare(k, treeNode.key);
            if (n == 0) {
                return true;
            }
            if (n < 0) {
                treeNode = treeNode.left;
                continue;
            }
            treeNode = treeNode.right;
        }
        return false;
    }

    public Object iterator() {
        Array<Object> array = new Array<Object>(new Object[0]);
        this.iteratorLoop(this.root, array);
        return new ArrayIterator<Object>(array);
    }

    public Object keys() {
        Array<Object> array = new Array<Object>(new Object[0]);
        this.keysLoop(this.root, array);
        return new ArrayIterator<Object>(array);
    }

    public TreeNode<K, V> setLoop(K k, V v, TreeNode<K, V> treeNode) {
        if (treeNode == null) {
            return new TreeNode<K, V>(null, k, v, null, null);
        }
        int n = this.compare(k, treeNode.key);
        if (n == 0) {
            return new TreeNode(treeNode.left, k, v, treeNode.right, treeNode == null ? 0 : treeNode._height);
        }
        if (n < 0) {
            TreeNode<K, V> treeNode2 = this.setLoop(k, v, treeNode.left);
            return this.balance(treeNode2, treeNode.key, treeNode.value, treeNode.right);
        }
        TreeNode<K, V> treeNode3 = this.setLoop(k, v, treeNode.right);
        return this.balance(treeNode.left, treeNode.key, treeNode.value, treeNode3);
    }

    public TreeNode<K, V> removeLoop(K k, TreeNode<K, V> treeNode) {
        if (treeNode == null) {
            throw HaxeException.wrap("Not_found");
        }
        int n = this.compare(k, treeNode.key);
        if (n == 0) {
            return this.merge(treeNode.left, treeNode.right);
        }
        if (n < 0) {
            return this.balance(this.removeLoop(k, treeNode.left), treeNode.key, treeNode.value, treeNode.right);
        }
        return this.balance(treeNode.left, treeNode.key, treeNode.value, this.removeLoop(k, treeNode.right));
    }

    public void iteratorLoop(TreeNode<K, V> treeNode, Array<V> array) {
        if (treeNode != null) {
            this.iteratorLoop(treeNode.left, array);
            array.push(treeNode.value);
            this.iteratorLoop(treeNode.right, array);
        }
    }

    public void keysLoop(TreeNode<K, V> treeNode, Array<K> array) {
        if (treeNode != null) {
            this.keysLoop(treeNode.left, array);
            array.push(treeNode.key);
            this.keysLoop(treeNode.right, array);
        }
    }

    public TreeNode<K, V> merge(TreeNode<K, V> treeNode, TreeNode<K, V> treeNode2) {
        if (treeNode == null) {
            return treeNode2;
        }
        if (treeNode2 == null) {
            return treeNode;
        }
        TreeNode<K, V> treeNode3 = this.minBinding(treeNode2);
        return this.balance(treeNode, treeNode3.key, treeNode3.value, this.removeMinBinding(treeNode2));
    }

    public TreeNode<K, V> minBinding(TreeNode<K, V> treeNode) {
        if (treeNode == null) {
            throw HaxeException.wrap("Not_found");
        }
        if (treeNode.left == null) {
            return treeNode;
        }
        return this.minBinding(treeNode.left);
    }

    public TreeNode<K, V> removeMinBinding(TreeNode<K, V> treeNode) {
        if (treeNode.left == null) {
            return treeNode.right;
        }
        return this.balance(this.removeMinBinding(treeNode.left), treeNode.key, treeNode.value, treeNode.right);
    }

    public TreeNode<K, V> balance(TreeNode<K, V> treeNode, K k, V v, TreeNode<K, V> treeNode2) {
        int n = 0;
        n = treeNode == null ? 0 : treeNode._height;
        int n2 = 0;
        n2 = treeNode2 == null ? 0 : treeNode2._height;
        if (n > n2 + 2) {
            int n3 = 0;
            TreeNode treeNode3 = treeNode.left;
            n3 = treeNode3 == null ? 0 : treeNode3._height;
            int n4 = 0;
            TreeNode treeNode4 = treeNode.right;
            int n5 = n4 = treeNode4 == null ? 0 : treeNode4._height;
            if (n3 >= n4) {
                return new TreeNode(treeNode.left, treeNode.key, treeNode.value, new TreeNode(treeNode.right, k, v, treeNode2, null), null);
            }
            return new TreeNode(new TreeNode(treeNode.left, treeNode.key, treeNode.value, treeNode.right.left, null), treeNode.right.key, treeNode.right.value, new TreeNode(treeNode.right.right, k, v, treeNode2, null), null);
        }
        if (n2 > n + 2) {
            int n6 = 0;
            TreeNode treeNode5 = treeNode2.right;
            n6 = treeNode5 == null ? 0 : treeNode5._height;
            int n7 = 0;
            TreeNode treeNode6 = treeNode2.left;
            int n8 = n7 = treeNode6 == null ? 0 : treeNode6._height;
            if (n6 > n7) {
                return new TreeNode<K, V>(new TreeNode<K, V>(treeNode, k, v, treeNode2.left, null), treeNode2.key, treeNode2.value, treeNode2.right, null);
            }
            return new TreeNode<K, V>(new TreeNode<K, V>(treeNode, k, v, treeNode2.left.left, null), treeNode2.left.key, treeNode2.left.value, new TreeNode(treeNode2.left.right, treeNode2.key, treeNode2.value, treeNode2.right, null), null);
        }
        return new TreeNode<K, V>(treeNode, k, v, treeNode2, (n > n2 ? n : n2) + 1);
    }

    public int compare(K k, K k2) {
        return Reflect.compare(k, k2);
    }

    public String toString() {
        if (this.root == null) {
            return "{}";
        }
        return "{" + this.root.toString() + "}";
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        switch (string.hashCode()) {
            case 3506402: {
                if (!string.equals("root")) break;
                bl2 = false;
                this.root = (TreeNode)object;
                return object;
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        switch (string.hashCode()) {
            case -1776922004: {
                if (!string.equals("toString")) break;
                bl4 = false;
                return new Closure(this, "toString");
            }
            case 3506402: {
                if (!string.equals("root")) break;
                bl4 = false;
                return this.root;
            }
            case 950484197: {
                if (!string.equals("compare")) break;
                bl4 = false;
                return new Closure(this, "compare");
            }
            case 113762: {
                if (!string.equals("set")) break;
                bl4 = false;
                return new Closure(this, "set");
            }
            case -339185956: {
                if (!string.equals("balance")) break;
                bl4 = false;
                return new Closure(this, "balance");
            }
            case 102230: {
                if (!string.equals("get")) break;
                bl4 = false;
                return new Closure(this, "get");
            }
            case 277888887: {
                if (!string.equals("removeMinBinding")) break;
                bl4 = false;
                return new Closure(this, "removeMinBinding");
            }
            case -934610812: {
                if (!string.equals("remove")) break;
                bl4 = false;
                return new Closure(this, "remove");
            }
            case -757252141: {
                if (!string.equals("minBinding")) break;
                bl4 = false;
                return new Closure(this, "minBinding");
            }
            case -1289358244: {
                if (!string.equals("exists")) break;
                bl4 = false;
                return new Closure(this, "exists");
            }
            case 103785528: {
                if (!string.equals("merge")) break;
                bl4 = false;
                return new Closure(this, "merge");
            }
            case 1182533742: {
                if (!string.equals("iterator")) break;
                bl4 = false;
                return new Closure(this, "iterator");
            }
            case 518409912: {
                if (!string.equals("keysLoop")) break;
                bl4 = false;
                return new Closure(this, "keysLoop");
            }
            case 3288564: {
                if (!string.equals("keys")) break;
                bl4 = false;
                return new Closure(this, "keys");
            }
            case 527064114: {
                if (!string.equals("iteratorLoop")) break;
                bl4 = false;
                return new Closure(this, "iteratorLoop");
            }
            case 1984755238: {
                if (!string.equals("setLoop")) break;
                bl4 = false;
                return new Closure(this, "setLoop");
            }
            case 1098338632: {
                if (!string.equals("removeLoop")) break;
                bl4 = false;
                return new Closure(this, "removeLoop");
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Array array) {
        boolean bl = true;
        switch (string.hashCode()) {
            case -1776922004: {
                if (!string.equals("toString")) break;
                bl = false;
                return this.toString();
            }
            case 113762: {
                if (!string.equals("set")) break;
                bl = false;
                this.set(array.__get(0), array.__get(1));
                break;
            }
            case 950484197: {
                if (!string.equals("compare")) break;
                bl = false;
                return this.compare(array.__get(0), array.__get(1));
            }
            case 102230: {
                if (!string.equals("get")) break;
                bl = false;
                return this.get(array.__get(0));
            }
            case -339185956: {
                if (!string.equals("balance")) break;
                bl = false;
                return this.balance((TreeNode)array.__get(0), array.__get(1), array.__get(2), (TreeNode)array.__get(3));
            }
            case -934610812: {
                if (!string.equals("remove")) break;
                bl = false;
                return this.remove(array.__get(0));
            }
            case 277888887: {
                if (!string.equals("removeMinBinding")) break;
                bl = false;
                return this.removeMinBinding((TreeNode)array.__get(0));
            }
            case -1289358244: {
                if (!string.equals("exists")) break;
                bl = false;
                return this.exists(array.__get(0));
            }
            case -757252141: {
                if (!string.equals("minBinding")) break;
                bl = false;
                return this.minBinding((TreeNode)array.__get(0));
            }
            case 1182533742: {
                if (!string.equals("iterator")) break;
                bl = false;
                return this.iterator();
            }
            case 103785528: {
                if (!string.equals("merge")) break;
                bl = false;
                return this.merge((TreeNode)array.__get(0), (TreeNode)array.__get(1));
            }
            case 3288564: {
                if (!string.equals("keys")) break;
                bl = false;
                return this.keys();
            }
            case 518409912: {
                if (!string.equals("keysLoop")) break;
                bl = false;
                this.keysLoop((TreeNode)array.__get(0), (Array)array.__get(1));
                break;
            }
            case 1984755238: {
                if (!string.equals("setLoop")) break;
                bl = false;
                return this.setLoop(array.__get(0), array.__get(1), (TreeNode)array.__get(2));
            }
            case 527064114: {
                if (!string.equals("iteratorLoop")) break;
                bl = false;
                this.iteratorLoop((TreeNode)array.__get(0), (Array)array.__get(1));
                break;
            }
            case 1098338632: {
                if (!string.equals("removeLoop")) break;
                bl = false;
                return this.removeLoop(array.__get(0), (TreeNode)array.__get(1));
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, array);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("root");
        super.__hx_getFields(array);
    }
}

