/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.dynamicform.controller;

import com.google.gson.Gson;
import com.trigyn.jws.dynamicform.service.DynamicFormService;
import com.trigyn.jws.usermanagement.security.config.Authorized;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class DynamicFormController {
    @Autowired
    private DynamicFormService dynamicFormService = null;

    @PostMapping(value={"/df"})
    @Authorized(moduleName="Form Builder")
    public String loadDynamicForm(@RequestParam(value="formId", required=true) String formId, HttpServletRequest httpServletRequest) throws Exception {
        return this.dynamicFormService.loadDynamicForm(formId, this.processRequestParams(httpServletRequest), null);
    }

    @PostMapping(value={"/sdf"}, consumes={"application/x-www-form-urlencoded"})
    @Authorized(moduleName="Form Builder")
    public Boolean saveDynamicForm(@RequestBody MultiValueMap<String, String> formData) throws Exception {
        return this.dynamicFormService.saveDynamicForm(formData);
    }

    @PostMapping(value={"/psdf"})
    @Authorized(moduleName="Form Builder")
    public Boolean saveDynamicForm(HttpServletRequest httpServletRequest) throws Exception {
        List formData = (List)new Gson().fromJson(httpServletRequest.getParameter("formData"), List.class);
        return this.dynamicFormService.saveDynamicForm(formData);
    }

    private Map<String, Object> processRequestParams(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        for (String requestParamKey : httpServletRequest.getParameterMap().keySet()) {
            if (!Boolean.FALSE.equals("formId".equalsIgnoreCase(requestParamKey))) continue;
            requestParams.put(requestParamKey, httpServletRequest.getParameter(requestParamKey));
        }
        return requestParams;
    }
}

