/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.dynamicform.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trigyn.jws.dbutils.vo.FileInfo;
import com.trigyn.jws.dynamicform.service.FilesStorageService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/cf"})
public class FileUploadController {
    @Autowired
    @Qualifier(value="file-system-storage")
    private FilesStorageService storageService = null;

    @PostMapping(value={"/upload"}, produces={"application/json"})
    @ResponseBody
    public String uploadFiles(@RequestParam(value="file") MultipartFile file, HttpServletRequest httpServletRequest) {
        String message = "";
        String fileConfigId = httpServletRequest.getParameter("fileConfigData");
        try {
            String fileId = this.storageService.save(file, fileConfigId);
            HashMap<String, String> uploadDetails = new HashMap<String, String>();
            uploadDetails.put("fileId", fileId);
            uploadDetails.put("success", "1");
            return new ObjectMapper().writeValueAsString(uploadDetails);
        }
        catch (Exception e) {
            message = "Fail to upload files!";
            return message;
        }
    }

    @PostMapping(value={"/m-upload"}, produces={"application/json"})
    @ResponseBody
    public String uploadFiles(@RequestParam(value="files[0]") MultipartFile[] files, HttpServletRequest httpServletRequest) {
        String fileConfigId = httpServletRequest.getParameter("fileConfigData");
        String message = "";
        try {
            ArrayList fileNames = new ArrayList();
            Arrays.asList(files).stream().forEach(file -> {
                String fileId = this.storageService.save((MultipartFile)file, fileConfigId);
                fileNames.add(fileId);
            });
            HashMap<String, Object> uploadDetails = new HashMap<String, Object>();
            uploadDetails.put("fileIds", fileNames);
            uploadDetails.put("success", "1");
            return new ObjectMapper().writeValueAsString(uploadDetails);
        }
        catch (Exception e) {
            message = "Fail to upload files!";
            return message;
        }
    }

    @GetMapping(value={"/files"})
    public ResponseEntity<List<FileInfo>> getListFiles() {
        List<FileInfo> fileInfos = this.storageService.loadAll();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(fileInfos);
    }

    @DeleteMapping(value={"/files/{fileId:.+}"})
    public ResponseEntity<?> deleteFile(@PathVariable String fileId) throws Exception {
        this.storageService.deleteFileById(fileId);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
    }

    @GetMapping(value={"/fileDetails"})
    public ResponseEntity<List<FileInfo>> getListFilesByIds(HttpServletRequest httpServletRequest) throws JsonMappingException, JsonProcessingException {
        String fileIds = httpServletRequest.getParameter("files");
        List fileIdList = (List)new ObjectMapper().readValue(fileIds, List.class);
        List<FileInfo> fileInfos = this.storageService.getFileDetailsByIds(fileIdList);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(fileInfos);
    }

    @GetMapping(value={"/files/{fileId:.+}"})
    public ResponseEntity<InputStreamResource> getFile(@PathVariable String fileId) throws IOException {
        Map<String, Object> fileInfo = this.storageService.load(fileId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDispositionFormData("attachment", fileInfo.get("fileName").toString());
        headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
        byte[] file = (byte[])fileInfo.get("file");
        InputStreamResource streamResource = new InputStreamResource((InputStream)new ByteArrayInputStream(file));
        return new ResponseEntity((Object)streamResource, (MultiValueMap)headers, HttpStatus.OK);
    }
}

