/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.dynamicform.dao;

import com.trigyn.jws.dbutils.repository.DBConnection;
import com.trigyn.jws.dynamicform.entities.DynamicForm;
import com.trigyn.jws.dynamicform.entities.DynamicFormSaveQuery;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DynamicFormCrudDAO
extends DBConnection {
    @Autowired
    public DynamicFormCrudDAO(DataSource dataSource) {
        super(dataSource);
    }

    public DynamicForm findDynamicFormById(String formId) {
        return (DynamicForm)this.hibernateTemplate.get(DynamicForm.class, (Serializable)((Object)formId));
    }

    public List<Map<String, Object>> getFormData(String selectionQuery) throws Exception {
        List data = null;
        data = this.jdbcTemplate.queryForList(selectionQuery);
        return data;
    }

    public void saveFormData(String saveTemplateQuery, Map<String, Object> parameters) {
        this.namedParameterJdbcTemplate.update(saveTemplateQuery, parameters);
    }

    public void saveDynamicFormData(DynamicForm dynamicForm) {
        this.getCurrentSession().saveOrUpdate((Object)dynamicForm);
    }

    public List<DynamicFormSaveQuery> findDynamicFormQueriesById(String formId) {
        Query query = this.getCurrentSession().createQuery("FROM DynamicFormSaveQuery AS dfs WHERE dfs.dynamicFormId = :formId ORDER BY dfs.sequence ASC ");
        query.setParameter("formId", (Object)formId);
        return query.list();
    }

    public void deleteFormQueries(String formId) {
        Query query = this.getCurrentSession().createQuery("DELETE FROM DynamicFormSaveQuery AS dfs WHERE dfs.dynamicFormId = :formId");
        query.setParameter("formId", (Object)formId);
        query.executeUpdate();
    }

    public void deleteFormQueriesByIds(String formId) {
        StringBuilder deleteFormQuery = new StringBuilder("DELETE FROM DynamicFormSaveQuery AS dfs WHERE dfs.dynamicFormId = :formId ");
        Query query = this.getCurrentSession().createQuery(deleteFormQuery.toString());
        query.setParameter("formId", (Object)formId);
        query.executeUpdate();
    }

    public String checkFormName(String formName) {
        Query query = this.getCurrentSession().createQuery("SELECT formId FROM DynamicForm  WHERE lower(formName) = lower(:formName)");
        query.setParameter("formName", (Object)formName);
        String data = (String)query.uniqueResult();
        return data;
    }

    public List<DynamicForm> getAllDynamicForms(Integer formTypeId) {
        Query query = this.getCurrentSession().createQuery("FROM DynamicForm AS df WHERE df.formTypeId = :formTypeId");
        query.setParameter("formTypeId", (Object)formTypeId);
        return query.list();
    }

    public DynamicForm getFormDetailsByName(String formName) {
        Query query = this.getCurrentSession().createQuery(" FROM DynamicForm  WHERE lower(formName) = lower(:formName)");
        query.setParameter("formName", (Object)formName);
        DynamicForm data = (DynamicForm)query.uniqueResult();
        return data;
    }

    public List<Map<String, Object>> getTableDetailsByTableName(String tableName) {
        String query = "select REPLACE(COLUMN_NAME, '_', '') as columnName, COLUMN_NAME as tableColumnName, COLUMN_KEY as columnKey, DATA_TYPE as dataType, REPLACE(CONCAT(UPPER(SUBSTRING(COLUMN_NAME,1,1)),LOWER(SUBSTRING(COLUMN_NAME,2))), '_', ' ') as fieldName, CASE WHEN DATA_TYPE = \"varchar\" THEN \"text\" WHEN DATA_TYPE = \"int\" THEN \"number\" WHEN DATA_TYPE LIKE (\"date%\") THEN \"datetime\" WHEN DATA_TYPE LIKE (\"time%\") THEN \"datetime\" ELSE \"textarea\" END as columnType, CASE WHEN DATA_TYPE = \"varchar\" THEN CHARACTER_MAXIMUM_LENGTH WHEN DATA_TYPE = \"int\" THEN NUMERIC_PRECISION ELSE CHARACTER_MAXIMUM_LENGTH END as columnSize from information_schema.COLUMNS where TABLE_NAME = :tableName and TABLE_SCHEMA = :schemaName order by ORDINAL_POSITION ASC ";
        List<Map<String, Object>> resultSet = new ArrayList<Map<String, Object>>();
        try (Connection connection = this.dataSource.getConnection();){
            String schemaName = connection.getCatalog();
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("tableName", tableName);
            parameterMap.put("schemaName", schemaName);
            resultSet = this.namedParameterJdbcTemplate.queryForList(query, parameterMap);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultSet;
    }

    public List<String> getAllTablesListInSchema() {
        String query = "SELECT TABLE_NAME FROM information_schema.TABLES WHERE TABLE_SCHEMA = :schemaName";
        List<String> resultSet = new ArrayList<String>();
        try (Connection connection = this.dataSource.getConnection();){
            String schemaName = connection.getCatalog();
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("schemaName", schemaName);
            resultSet = this.namedParameterJdbcTemplate.queryForList(query, parameterMap, String.class);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return resultSet;
    }

    public List<String> getAllViewsListInSchema() {
        String query = "SELECT TABLE_NAME FROM information_schema.VIEWS WHERE TABLE_SCHEMA = :schemaName";
        List<String> resultSet = new ArrayList<String>();
        try (Connection connection = this.dataSource.getConnection();){
            String schemaName = connection.getCatalog();
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("schemaName", schemaName);
            resultSet = this.namedParameterJdbcTemplate.queryForList(query, parameterMap, String.class);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return resultSet;
    }

    public List<Map<String, Object>> getTableInformationByName(String tableName) {
        String query = "select COLUMN_NAME as columnName, COLUMN_KEY as columnKey, DATA_TYPE as dataType,CHARACTER_MAXIMUM_LENGTH as characterMaximumLength from information_schema.COLUMNS where TABLE_NAME = :tableName and TABLE_SCHEMA = :schemaName ORDER BY ORDINAL_POSITION ASC ";
        List<Map<String, Object>> resultSet = new ArrayList<Map<String, Object>>();
        try (Connection connection = this.dataSource.getConnection();){
            String schemaName = connection.getCatalog();
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("tableName", tableName);
            parameterMap.put("schemaName", schemaName);
            resultSet = this.namedParameterJdbcTemplate.queryForList(query, parameterMap);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultSet;
    }
}

