/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.dynamicform.service;

import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.service.ModuleVersionService;
import com.trigyn.jws.dbutils.utils.FileUtilities;
import com.trigyn.jws.dynamicform.dao.DynamicFormCrudDAO;
import com.trigyn.jws.dynamicform.entities.DynamicForm;
import com.trigyn.jws.dynamicform.entities.DynamicFormSaveQuery;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.templating.utils.TemplatingUtils;
import com.trigyn.jws.templating.vo.TemplateVO;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;

@Service
@Transactional
public class DynamicFormService {
    private static final String DATE = "date";
    private static final String TIMESTAMP = "timestamp";
    private static final String DECIMAL = "decimal";
    private static final String TEXT = "text";
    private static final String INT = "int";
    private static final String VARCHAR = "varchar";
    @Autowired
    private TemplatingUtils templateEngine = null;
    @Autowired
    private DynamicFormCrudDAO dynamicFormDAO = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private DBTemplatingService templateService = null;
    @Autowired
    private FileUtilities fileUtilities = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private ModuleVersionService moduleVersionService = null;
    private static final Logger logger = LogManager.getLogger(DynamicFormService.class);

    public String loadDynamicForm(String formId, Map<String, Object> requestParam, Map<String, Object> additionalParam) {
        try {
            String selectTemplateQuery = null;
            String templateHtml = null;
            String selectQuery = null;
            String formBody = null;
            HashMap<String, Object> formHtmlTemplateMap = new HashMap<String, Object>();
            String selectQueryFile = "selectQuery";
            String htmlBodyFile = "htmlContent";
            DynamicForm form = this.dynamicFormDAO.findDynamicFormById(formId);
            String formName = form.getFormName();
            String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
            if (environment.equalsIgnoreCase("dev")) {
                selectQuery = this.getContentForDevEnvironment(form, form.getFormSelectQuery(), selectQueryFile);
                formBody = this.getContentForDevEnvironment(form, form.getFormBody(), htmlBodyFile);
            } else {
                selectQuery = form.getFormSelectQuery();
                formBody = form.getFormBody();
            }
            List<Map<String, Object>> selectResultSet = null;
            if (additionalParam != null) {
                requestParam.putAll(additionalParam);
            }
            if (StringUtils.isNotEmpty((CharSequence)(selectTemplateQuery = this.templateEngine.processTemplateContents(selectQuery, formName, requestParam)))) {
                selectResultSet = this.dynamicFormDAO.getFormData(selectTemplateQuery.toString());
            }
            formHtmlTemplateMap.put("resultSet", selectResultSet);
            if (selectResultSet != null && selectResultSet.size() > 0) {
                formHtmlTemplateMap.put("resultSetObject", selectResultSet.get(0));
            } else {
                formHtmlTemplateMap.put("resultSetObject", new HashMap());
            }
            formHtmlTemplateMap.put("formId", formId);
            formHtmlTemplateMap.put("requestDetails", requestParam);
            formHtmlTemplateMap.put("entityType", "form");
            formHtmlTemplateMap.put("entityName", formName);
            templateHtml = this.templateEngine.processTemplateContents(formBody, formName, formHtmlTemplateMap);
            Boolean includeLayout = requestParam.get("includeLayout") == null ? Boolean.TRUE : Boolean.parseBoolean(requestParam.get("includeLayout").toString());
            if (Boolean.TRUE.equals(includeLayout)) {
                return this.menuService.getTemplateWithSiteLayoutWithoutProcess(templateHtml, formHtmlTemplateMap);
            }
            return templateHtml;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Boolean saveDynamicForm(MultiValueMap<String, String> formData) throws Exception {
        String saveTemplateQuery = null;
        String formId = (String)formData.getFirst((Object)"formId");
        DynamicForm form = this.dynamicFormDAO.findDynamicFormById(formId);
        String formName = form.getFormName();
        HashMap<String, MultiValueMap<String, String>> saveTemplateMap = new HashMap<String, MultiValueMap<String, String>>();
        saveTemplateMap.put("formData", formData);
        String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
        String saveQuery = "saveQuery-";
        List<DynamicFormSaveQuery> dynamicFormSaveQueries = this.dynamicFormDAO.findDynamicFormQueriesById(formId);
        for (DynamicFormSaveQuery dynamicFormSaveQuery : dynamicFormSaveQueries) {
            String formSaveQuery = null;
            formSaveQuery = environment.equalsIgnoreCase("dev") ? this.getContentForDevEnvironment(form, dynamicFormSaveQuery.getDynamicFormSaveQuery(), saveQuery + dynamicFormSaveQuery.getSequence()) : dynamicFormSaveQuery.getDynamicFormSaveQuery();
            saveTemplateQuery = this.templateEngine.processTemplateContents(formSaveQuery, formName, saveTemplateMap);
            this.dynamicFormDAO.saveFormData(saveTemplateQuery, new HashMap<String, Object>());
        }
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Boolean saveDynamicForm(List<Map<String, String>> formData) throws Exception {
        String saveTemplateQuery = null;
        Map<String, Object> formDetails = this.createParamterMap(formData);
        String formId = formDetails.get("formId").toString();
        DynamicForm form = this.dynamicFormDAO.findDynamicFormById(formId);
        String formName = form.getFormName();
        String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
        String saveQuery = "saveQuery-";
        List<DynamicFormSaveQuery> dynamicFormSaveQueries = this.dynamicFormDAO.findDynamicFormQueriesById(formId);
        for (DynamicFormSaveQuery dynamicFormSaveQuery : dynamicFormSaveQueries) {
            String formSaveQuery = null;
            formSaveQuery = environment.equalsIgnoreCase("dev") ? this.getContentForDevEnvironment(form, dynamicFormSaveQuery.getDynamicFormSaveQuery(), saveQuery + dynamicFormSaveQuery.getSequence()) : dynamicFormSaveQuery.getDynamicFormSaveQuery();
            saveTemplateQuery = this.templateEngine.processTemplateContents(formSaveQuery, formName, formDetails);
            this.dynamicFormDAO.saveFormData(saveTemplateQuery, formDetails);
        }
        return true;
    }

    public String getContentForDevEnvironment(DynamicForm form, String dbContent, String fileName) throws Exception {
        String ftlCustomExtension = ".tgn";
        String templateDirectory = "DynamicForm";
        Object folderLocation = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "template-storage-path");
        File directory = new File((String)(folderLocation = (String)folderLocation + File.separator + templateDirectory + File.separator + form.getFormName()));
        if (!directory.exists()) {
            return dbContent;
        }
        File selectFile = new File((String)folderLocation + File.separator + fileName + ftlCustomExtension);
        if (selectFile.exists()) {
            return this.fileUtilities.readContentsOfFile(selectFile.getAbsolutePath());
        }
        return dbContent;
    }

    public Map<String, String> createDefaultFormByTableName(String tableName, List<Map<String, Object>> tableDetails) {
        HashMap<String, String> templatesMap = new HashMap<String, String>();
        HashMap<String, List<Map<String, Object>>> parameters = new HashMap<String, List<Map<String, Object>>>();
        parameters.put("columnDetails", tableDetails);
        try {
            TemplateVO templateVO = this.templateService.getTemplateByName("system-form-html-template");
            String template = this.templateEngine.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), parameters);
            templatesMap.put("form-template", template);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.createSaveUpdateQueryTemplate(tableDetails, tableName, templatesMap);
        return templatesMap;
    }

    public List<Map<String, Object>> getTableInformationByName(String tableName) {
        return this.dynamicFormDAO.getTableInformationByName(tableName);
    }

    public List<Map<String, Object>> getTableDetailsByTableName(String tableName) {
        return this.dynamicFormDAO.getTableDetailsByTableName(tableName);
    }

    private void createSaveUpdateQueryTemplate(List<Map<String, Object>> tableInformation, String tableName, Map<String, String> templatesMap) {
        StringJoiner insertJoiner = new StringJoiner(",", "INSERT INTO " + tableName + " (", ")");
        StringJoiner insertValuesJoiner = new StringJoiner(",", " VALUES (", ")");
        for (Map<String, Object> info : tableInformation) {
            String columnName = info.get("tableColumnName").toString();
            String dataType = info.get("dataType").toString();
            String columnKey = info.get("columnKey").toString();
            insertJoiner.add(columnName);
            this.joinQueryBuilder(insertValuesJoiner, columnName, dataType, false);
        }
        StringBuilder queryBuilder = new StringBuilder(insertJoiner.toString());
        queryBuilder.append(insertValuesJoiner);
        HashMap<String, String> saveQueryparameters = new HashMap<String, String>();
        saveQueryparameters.put("insertQuery", queryBuilder.toString());
        StringJoiner updateQuery = new StringJoiner(",", "UPDATE " + tableName + " SET ", "");
        StringJoiner updateWhereQuery = new StringJoiner(" AND ", " WHERE ", "");
        for (Map map : tableInformation) {
            String columnName = map.get("tableColumnName").toString();
            String dataType = map.get("dataType").toString();
            String columnKey = map.get("columnKey").toString();
            if ("PRI".equals(columnKey)) {
                this.joinQueryBuilder(updateWhereQuery, columnName, dataType, true);
                continue;
            }
            this.joinQueryBuilder(updateQuery, columnName, dataType, true);
        }
        StringBuilder updateQueryBuilder = new StringBuilder(updateQuery.toString());
        updateQueryBuilder.append(updateWhereQuery);
        saveQueryparameters.put("updateQuery", updateQueryBuilder.toString());
        try {
            TemplateVO templateVO = this.templateService.getTemplateByName("system-form-save-query-template");
            String template = this.templateEngine.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), saveQueryparameters);
            templatesMap.put("save-template", template);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void joinQueryBuilder(StringJoiner insertValuesJoiner, String columnName, String dataType, boolean showColumnName) {
        String formFieldName = columnName.replace("_", "");
        if (dataType.contains(VARCHAR) || dataType.contains(TEXT)) {
            String value = showColumnName ? columnName + " = :" + formFieldName : ":" + formFieldName;
            insertValuesJoiner.add(value.replace("\\", ""));
        } else if (dataType.contains(INT) || dataType.contains(DECIMAL)) {
            String value = showColumnName ? columnName + " = :" + formFieldName : ":" + formFieldName;
            insertValuesJoiner.add(value.replace("\\", ""));
        } else if (dataType.contains(DATE) || dataType.contains(TIMESTAMP)) {
            insertValuesJoiner.add((CharSequence)(showColumnName ? columnName + " = NOW()" : "NOW()"));
        }
    }

    private Map<String, Object> createParamterMap(List<Map<String, String>> formData) {
        HashMap<String, Object> formParameters = new HashMap<String, Object>();
        for (Map<String, String> data : formData) {
            String valueType = data.getOrDefault("type", VARCHAR);
            Object value = this.getDataInTypeFormat(data.get("value"), valueType);
            formParameters.put(data.get("name"), value);
        }
        return formParameters;
    }

    private Object getDataInTypeFormat(String value, String valueType) {
        if (valueType.equals(INT)) {
            return Integer.parseInt(value);
        }
        if (valueType.equals(DECIMAL)) {
            return Double.parseDouble(value);
        }
        if (valueType.equals(DATE) || valueType.equals(TIMESTAMP)) {
            Date dateData = new Date();
            try {
                dateData = DateFormat.getInstance().parse(value);
            }
            catch (ParseException e) {
                logger.warn("Error paring the date : ", (Throwable)e);
            }
            return dateData;
        }
        return value;
    }
}

