/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.dynamicform.service;

import com.trigyn.jws.dbutils.service.PropertyMasterService;
import com.trigyn.jws.dbutils.spi.IUserDetailsService;
import com.trigyn.jws.dbutils.vo.FileInfo;
import com.trigyn.jws.dbutils.vo.UserDetailsVO;
import com.trigyn.jws.dynamicform.dao.FileUploadRepository;
import com.trigyn.jws.dynamicform.entities.FileUpload;
import com.trigyn.jws.dynamicform.service.FilesStorageService;
import com.trigyn.jws.dynamicform.utils.CryptoUtils;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileSystemUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
@Qualifier(value="file-system-storage")
@Transactional
public class FilesStorageServiceImpl
implements FilesStorageService {
    private static final Logger logger = LogManager.getLogger(FilesStorageServiceImpl.class);
    @Autowired
    private PropertyMasterService propertyMasterService = null;
    @Autowired
    private IUserDetailsService userdetailsService = null;
    @Autowired
    private FileUploadRepository fileUploadRepository = null;
    private static final String JWS_SALT = "main alag duniya";

    @Override
    public void init() {
        String fileUploadDir = null;
        try {
            fileUploadDir = this.propertyMasterService.findPropertyMasterValue("file-upload-location");
            Files.createDirectory(Paths.get(fileUploadDir, new String[0]), new FileAttribute[0]);
        }
        catch (Exception execption) {
            logger.error("Error while init of file stoarage ", (Object)execption.getMessage());
        }
    }

    @Override
    public String save(MultipartFile file, String fileConfigId) {
        try {
            LocalDate localDate = LocalDate.now();
            Integer year = localDate.getYear();
            Integer month = localDate.getMonthValue();
            Integer date = localDate.getDayOfMonth();
            String fileUploadDir = this.propertyMasterService.findPropertyMasterValue("file-upload-location");
            StringJoiner location = new StringJoiner("" + File.separatorChar);
            location.add(fileUploadDir);
            location.add(year.toString()).add(month.toString()).add(date.toString());
            if (Boolean.FALSE.equals(new File(location.toString()).exists())) {
                Files.createDirectories(Paths.get(location.toString(), new String[0]), new FileAttribute[0]);
            }
            FileUpload fileUpload = this.saveFileDetails(location.toString(), file.getOriginalFilename(), fileConfigId);
            Path root = Paths.get(location.toString(), new String[0]);
            Files.copy(file.getInputStream(), root.resolve(fileUpload.getPhysicalFileName()), new CopyOption[0]);
            CryptoUtils.encrypt(JWS_SALT, root.resolve(fileUpload.getPhysicalFileName()).toFile(), root.resolve(fileUpload.getPhysicalFileName()).toFile());
            return fileUpload.getFileUploadId();
        }
        catch (Exception exception) {
            logger.error("Could not store the file. Error: ", (Throwable)exception);
            return null;
        }
    }

    private FileUpload saveFileDetails(String location, String originalFilename, String fileConfigId) {
        UserDetailsVO userDetailsVO = this.userdetailsService.getUserDetails();
        FileUpload fileUpload = new FileUpload();
        fileUpload.setFilePath(location);
        fileUpload.setOriginalFileName(originalFilename);
        fileUpload.setPhysicalFileName(UUID.randomUUID().toString());
        fileUpload.setUpdatedBy(userDetailsVO.getUserName());
        fileUpload.setFileConfigId(fileConfigId);
        return (FileUpload)this.fileUploadRepository.save(fileUpload);
    }

    @Override
    public Map<String, Object> load(String fileUploadId) {
        try {
            HashMap<String, Object> details = new HashMap<String, Object>();
            FileUpload fileUploadDetails = (FileUpload)this.fileUploadRepository.findById(fileUploadId).orElseThrow(() -> new Exception("file not found with id : " + fileUploadId));
            Path root = Paths.get(fileUploadDetails.getFilePath(), new String[0]);
            Path filePath = root.resolve(fileUploadDetails.getPhysicalFileName());
            UrlResource resource = new UrlResource(filePath.toUri());
            if (resource.exists() || resource.isReadable()) {
                File newFile = resource.getFile();
                byte[] newFiles = CryptoUtils.decrypt(JWS_SALT, newFile, null);
                details.put("file", newFiles);
                details.put("fileName", fileUploadDetails.getOriginalFileName());
                return details;
            }
            throw new RuntimeException("Could not read the file!");
        }
        catch (Exception e) {
            logger.error("Error: ", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public void deleteAll() {
        try {
            this.fileUploadRepository.deleteAll();
            String fileUploadDir = this.propertyMasterService.findPropertyMasterValue("file-upload-location");
            Path root = Paths.get(fileUploadDir, new String[0]);
            FileSystemUtils.deleteRecursively((File)root.toFile());
        }
        catch (Exception e) {
            logger.error("Error: ", (Object)e.getMessage());
        }
    }

    @Override
    public List<FileInfo> loadAll() {
        try {
            List fileUploads = this.fileUploadRepository.findAll();
            List<FileInfo> fileInfos = fileUploads.stream().map(files -> {
                File file = new File(files.getFilePath());
                return new FileInfo(files.getFileUploadId(), files.getOriginalFileName(), Long.valueOf(file.length()));
            }).collect(Collectors.toList());
            return fileInfos;
        }
        catch (Exception e) {
            logger.error("Could not load the files!");
            return null;
        }
    }

    @Override
    public List<FileInfo> getFileDetailsByIds(List<String> fileIdList) {
        List<FileUpload> fileUploads = this.fileUploadRepository.findAllByIds(fileIdList);
        List<FileInfo> fileInfos = fileUploads.stream().map(files -> {
            File file = new File(files.getFilePath());
            return new FileInfo(files.getFileUploadId(), files.getOriginalFileName(), Long.valueOf(file.length()));
        }).collect(Collectors.toList());
        return fileInfos;
    }

    @Override
    public void deleteFileById(String fileId) throws Exception {
        FileUpload fileUploadDetails = (FileUpload)this.fileUploadRepository.findById(fileId).orElseThrow(() -> new Exception("file not found with id : " + fileId));
        Path root = Paths.get(fileUploadDetails.getFilePath(), new String[0]);
        Path filePath = root.resolve(fileUploadDetails.getPhysicalFileName());
        UrlResource resource = new UrlResource(filePath.toUri());
        if (resource.exists() || resource.isReadable()) {
            this.fileUploadRepository.deleteById(fileId);
            resource.getFile().delete();
        }
    }
}

