/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.repository;

import com.trigyn.jws.dbutils.repository.DBConnection;
import com.trigyn.jws.usermanagement.entities.JwsEntityRoleAssociation;
import java.io.Serializable;
import javax.sql.DataSource;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JwsEntityRoleAssociationDAO
extends DBConnection {
    private static final String QUERY_TO_GET_ENTITY_ROLE_ASSOC_ID = " SELECT jera.entityRoleId FROM JwsEntityRoleAssociation jera WHERE jera.entityId=:entityId AND jera.entityName=:entityName AND jera.moduleId=:moduleId AND jera.roleId=:roleId";

    @Autowired
    public JwsEntityRoleAssociationDAO(DataSource dataSource) {
        super(dataSource);
    }

    public JwsEntityRoleAssociation findPermissionById(String entityRoleId) {
        JwsEntityRoleAssociation entityRole = (JwsEntityRoleAssociation)this.hibernateTemplate.get(JwsEntityRoleAssociation.class, (Serializable)((Object)entityRoleId));
        if (entityRole != null) {
            this.getCurrentSession().evict((Object)entityRole);
        }
        return entityRole;
    }

    public JwsEntityRoleAssociation findJERAByName(String entityId, String entityName, String moduleId, String roleId) {
        Query query = this.getCurrentSession().createQuery(QUERY_TO_GET_ENTITY_ROLE_ASSOC_ID);
        query.setParameter("entityId", (Object)entityId);
        query.setParameter("entityName", (Object)entityName);
        query.setParameter("moduleId", (Object)moduleId);
        query.setParameter("roleId", (Object)roleId);
        Object jeraValueObj = query.uniqueResult();
        if (jeraValueObj != null) {
            String jeraId = jeraValueObj.toString();
            JwsEntityRoleAssociation entityRole = (JwsEntityRoleAssociation)this.hibernateTemplate.get(JwsEntityRoleAssociation.class, (Serializable)((Object)jeraId));
            return entityRole;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void saveJwsEntityRoleAssociation(JwsEntityRoleAssociation entityRole) {
        try {
            JwsEntityRoleAssociation jera = this.findJERAByName(entityRole.getEntityId(), entityRole.getEntityName(), entityRole.getModuleId(), entityRole.getRoleId());
            if (jera != null) {
                this.getCurrentSession().evict((Object)jera);
            }
            if (entityRole.getEntityRoleId() == null || this.findPermissionById(entityRole.getEntityRoleId()) == null && jera == null) {
                this.getCurrentSession().save((Object)entityRole);
            } else {
                if (jera != null) {
                    entityRole.setEntityRoleId(jera.getEntityRoleId());
                }
                this.getCurrentSession().saveOrUpdate((Object)entityRole);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

