/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.repository;

import com.trigyn.jws.usermanagement.entities.JwsEntityRoleAssociation;
import com.trigyn.jws.usermanagement.vo.JwsRoleVO;
import com.trigyn.jws.usermanagement.vo.SiteLayoutVO;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface JwsEntityRoleAssociationRepository
extends JpaRepository<JwsEntityRoleAssociation, String> {
    @Query(value=" SELECT entityRoleId FROM JwsEntityRoleAssociation WHERE entityId=:entityId AND roleId=:roleId ")
    public String getEntityRoleIdByEntityAndRoleId(String var1, String var2);

    @Query(value=" FROM JwsEntityRoleAssociation WHERE entityId=:entityId AND moduleId=:moduleId ")
    public List<JwsEntityRoleAssociation> getEntityRoles(String var1, String var2);

    @Query(value=" SELECT new com.trigyn.jws.usermanagement.vo.JwsRoleVO( r.roleId,r.roleName) FROM JwsEntityRoleAssociation AS jera INNER JOIN jera.role  AS r WHERE jera.entityId=:entityId AND jera.moduleId=:moduleId  AND jera.isActive=:isActive")
    public List<JwsRoleVO> getRoles(String var1, String var2, Integer var3);

    @Modifying
    @Query(value=" UPDATE JwsEntityRoleAssociation SET isActive=:isActive WHERE moduleTypeId =:moduleTypeId  AND roleId=:roleId")
    public void updateEntityRelatedToModule(Integer var1, String var2, Integer var3);

    @Query(value=" FROM JwsEntityRoleAssociation WHERE moduleTypeId=:commonModuleTypeId  GROUP BY entityId ")
    public List<JwsEntityRoleAssociation> findEntityByModuleTypeId(Integer var1);

    @Query(value=" FROM JwsEntityRoleAssociation WHERE entityRoleId=:entityRoleID")
    public JwsEntityRoleAssociation getJwsEntityRoleAssociation(String var1);

    @Query(value=" SELECT DISTINCT jera.entityName FROM JwsEntityRoleAssociation AS jera INNER JOIN JwsMasterModules AS jmm ON jmm.moduleId = jera.moduleId  AND jmm.moduleName = :moduleName WHERE jera.entityName = :entityName ")
    public String getEntityNameByEntityAndRoleId(String var1, String var2);

    @Query(value="SELECT new com.trigyn.jws.usermanagement.vo.SiteLayoutVO(ml.moduleUrl, COUNT(jera.roleId))  FROM JwsEntityRoleAssociation jera INNER JOIN ModuleListing ml ON jera.entityId= ml.moduleId  INNER JOIN JwsRole jr ON jera.roleId = jr.roleId  INNER JOIN ml.moduleListingI18ns AS mlI18n ON mlI18n.id.languageId = 1   WHERE  jera.isActive=:isActive AND jr.roleName IN(:roleNames) AND  ml.moduleUrl LIKE %:moduleUrl% ")
    public List<SiteLayoutVO> hasAccessToSiteLayout(String var1, List<String> var2, Integer var3);

    @Query(value="SELECT new com.trigyn.jws.usermanagement.vo.SiteLayoutVO(mlI18n.moduleName, ml.moduleUrl) FROM ModuleListing ml INNER JOIN ml.moduleListingI18ns AS mlI18n ON mlI18n.id.languageId = 1  WHERE ml.moduleUrl LIKE %:moduleUrl%  ")
    public List<SiteLayoutVO> getSiteLayoutNameByUrl(String var1);
}

