/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.repository;

import com.trigyn.jws.dbutils.repository.DBConnection;
import com.trigyn.jws.usermanagement.entities.JwsRole;
import com.trigyn.jws.usermanagement.entities.JwsUser;
import com.trigyn.jws.usermanagement.entities.JwsUserRoleAssociation;
import com.trigyn.jws.usermanagement.security.config.TwoFactorGoogleUtil;
import com.trigyn.jws.usermanagement.utils.Constants;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import javax.transaction.Transactional;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserManagementDAO
extends DBConnection {
    @PersistenceContext
    private EntityManager em;

    @Autowired
    public UserManagementDAO(DataSource dataSource) {
        super(dataSource);
    }

    public void deleteUserRoleAssociation(String userId) {
        Query query = this.getCurrentSession().createQuery("DELETE FROM JwsUserRoleAssociation WHERE userId=:userId");
        query.setParameter("userId", (Object)userId);
        query.executeUpdate();
    }

    public List<String> getRoleIdsByUserId(String userId) throws Exception {
        Query query = this.getCurrentSession().createQuery("SELECT roleId FROM JwsUserRoleAssociation WHERE userId =:userId");
        query.setParameter("userId", (Object)userId);
        List roleIds = query.getResultList();
        return roleIds;
    }

    @Transactional
    public JwsUser saveUserData(JwsUser jwsUser) {
        jwsUser.setRegisteredBy(Constants.AuthType.OAUTH.getAuthType());
        if (jwsUser.getUserId() == null) {
            TwoFactorGoogleUtil twoFactorGoogleUtil = new TwoFactorGoogleUtil();
            jwsUser.setSecretKey(twoFactorGoogleUtil.generateSecretKey());
        }
        this.getCurrentSession().saveOrUpdate((Object)jwsUser);
        return jwsUser;
    }

    @Transactional
    public JwsUser updateUserData(JwsUser jwsUser) {
        this.getCurrentSession().saveOrUpdate((Object)jwsUser);
        return jwsUser;
    }

    @Transactional
    public void saveRoleData(JwsRole jwsRole) {
        this.getCurrentSession().saveOrUpdate((Object)jwsRole);
    }

    @Transactional
    public void saveAuthenticatedRole(String userId) {
        JwsUserRoleAssociation userRoleAssociation = new JwsUserRoleAssociation();
        userRoleAssociation.setRoleId("2ace542e-0c63-11eb-9cf5-f48e38ab9348");
        userRoleAssociation.setUserId(userId);
        userRoleAssociation.setUpdatedDate(new Date());
        this.getCurrentSession().save((Object)userRoleAssociation);
    }

    public JwsUser findJwsUserById(String userId) {
        JwsUser user = (JwsUser)this.hibernateTemplate.get(JwsUser.class, (Serializable)((Object)userId));
        if (user != null) {
            this.getCurrentSession().evict((Object)user);
        }
        return user;
    }

    @Transactional
    public void saveJwsUser(JwsUser user) {
        if (user.getUserId() == null || this.findJwsUserById(user.getUserId()) == null) {
            this.getCurrentSession().save((Object)user);
        } else {
            this.getCurrentSession().saveOrUpdate((Object)user);
        }
    }

    public JwsRole findJwsRoleById(String roleId) {
        JwsRole role = (JwsRole)this.hibernateTemplate.get(JwsRole.class, (Serializable)((Object)roleId));
        if (role != null) {
            this.getCurrentSession().evict((Object)role);
        }
        return role;
    }

    @Transactional
    public void saveJwsRole(JwsRole role) {
        if (role.getRoleId() == null || this.findJwsRoleById(role.getRoleId()) == null) {
            this.getCurrentSession().save((Object)role);
        } else {
            this.getCurrentSession().saveOrUpdate((Object)role);
        }
    }
}

