/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trigyn.jws.dbutils.entities.PropertyMaster;
import com.trigyn.jws.dbutils.repository.PropertyMasterRepository;
import com.trigyn.jws.usermanagement.entities.JwsAuthenticationType;
import com.trigyn.jws.usermanagement.repository.JwsAuthenticationTypeRepository;
import com.trigyn.jws.usermanagement.vo.JwsAuthenticationTypeVO;
import com.trigyn.jws.usermanagement.vo.JwsMultiAuthVerificationVO;
import com.trigyn.jws.usermanagement.vo.MultiAuthSecurityDetailsVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationSecurityDetails {
    private static final Logger logger = LogManager.getLogger(ApplicationSecurityDetails.class);
    private Boolean isAuthenticationEnabled = null;
    private Map<String, Object> authenticationDetails = new HashMap<String, Object>();
    private String baseUrl = null;
    @Autowired
    private PropertyMasterRepository propertyMasterRepository = null;
    @Autowired
    private JwsAuthenticationTypeRepository authenticationTypeRepository = null;
    final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public ApplicationSecurityDetails(PropertyMasterRepository propertyMasterRepository) throws Exception {
        PropertyMaster propertyMaster = propertyMasterRepository.findByOwnerTypeAndOwnerIdAndPropertyName("system", "system", "enable-user-management");
        this.isAuthenticationEnabled = Boolean.parseBoolean(propertyMaster.getPropertyValue());
        PropertyMaster propertyMasterBaseUrl = propertyMasterRepository.findByOwnerTypeAndOwnerIdAndPropertyName("system", "system", "base-url");
        this.baseUrl = propertyMasterBaseUrl.getPropertyValue();
    }

    public Boolean getIsAuthenticationEnabled() {
        return this.isAuthenticationEnabled;
    }

    public Map<String, Object> getAuthenticationDetails() {
        if (this.isAuthenticationEnabled != null) {
            List<JwsAuthenticationType> authenticationTypes = this.authenticationTypeRepository.getAuthenticationTypes();
            ArrayList<MultiAuthSecurityDetailsVO> multiAuthDetails = new ArrayList<MultiAuthSecurityDetailsVO>();
            if (authenticationTypes != null && !authenticationTypes.isEmpty()) {
                for (JwsAuthenticationType authenticationType : authenticationTypes) {
                    JwsAuthenticationTypeVO authenticationTypeVO = new JwsAuthenticationTypeVO().convertEntityToVO(authenticationType);
                    String authenticationProperties = authenticationTypeVO.getAuthenticationProperties();
                    if (authenticationProperties == null) continue;
                    try {
                        JwsMultiAuthVerificationVO authVerificationVOs = (JwsMultiAuthVerificationVO)this.mapper.readValue(authenticationProperties, (TypeReference)new TypeReference<JwsMultiAuthVerificationVO>(){});
                        if (authVerificationVOs == null) continue;
                        MultiAuthSecurityDetailsVO userLoginVO = new MultiAuthSecurityDetailsVO();
                        userLoginVO.setAuthenticationTypeVO(authenticationTypeVO);
                        userLoginVO.setVerificationTypeVO(authVerificationVOs);
                        multiAuthDetails.add(userLoginVO);
                    }
                    catch (JsonProcessingException error) {
                        logger.error("ERROR : " + error);
                    }
                }
            }
            this.authenticationDetails.put("isAuthenticationEnabled", this.isAuthenticationEnabled);
            this.authenticationDetails.put("authenticationDetails", multiAuthDetails);
            return this.authenticationDetails;
        }
        return null;
    }

    public void resetApplicationSecurityDetails() {
        PropertyMaster propertyMaster = this.propertyMasterRepository.findByOwnerTypeAndOwnerIdAndPropertyName("system", "system", "enable-user-management");
        this.isAuthenticationEnabled = Boolean.parseBoolean(propertyMaster.getPropertyValue());
        this.authenticationDetails = this.getAuthenticationDetails();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

