/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.dbutils.repository.IModuleListingRepository;
import com.trigyn.jws.dbutils.utils.ApplicationContextUtils;
import com.trigyn.jws.usermanagement.security.config.Authorized;
import com.trigyn.jws.usermanagement.security.config.EntityValidator;
import com.trigyn.jws.usermanagement.security.config.EntityValidatorFactory;
import com.trigyn.jws.usermanagement.security.config.UserInformation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class AuthorizedValidator {
    private static final Logger logger = LogManager.getLogger(AuthorizedValidator.class);
    @Autowired
    private EntityValidatorFactory entityValidatorFactory = null;
    @Autowired
    private IModuleListingRepository moduleListingRepository = null;
    @Autowired
    private ServletContext servletContext = null;

    @Pointcut(value="@annotation(com.trigyn.jws.usermanagement.security.config.Authorized)")
    private void customHasPermission() {
    }

    @Around(value="com.trigyn.jws.usermanagement.security.config.AuthorizedValidator.customHasPermission()")
    public Object validateEntityPermission(ProceedingJoinPoint a_joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)a_joinPoint.getSignature();
        Method method = signature.getMethod();
        ArrayList<String> roleNames = new ArrayList<String>();
        HttpServletRequest requestObject = this.getRequest();
        HttpServletResponse responseObject = this.getResponse();
        Authorized myAnnotation = method.getAnnotation(Authorized.class);
        Authentication authentication = null;
        if (requestObject.getSession().getAttribute("SPRING_SECURITY_CONTEXT") != null) {
            authentication = ((SecurityContextImpl)requestObject.getSession().getAttribute("SPRING_SECURITY_CONTEXT")).getAuthentication();
        }
        if (authentication == null) {
            authentication = SecurityContextHolder.getContext().getAuthentication();
        }
        String moduleName = myAnnotation.moduleName();
        if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            roleNames.add("ANONYMOUS");
        } else {
            UserInformation userInformation = (UserInformation)authentication.getPrincipal();
            roleNames.addAll(userInformation.getRoles());
        }
        EntityValidator entityValidator = this.entityValidatorFactory.createEntityValidator(moduleName);
        boolean hasAccess = entityValidator.hasAccessToEntity(requestObject, roleNames, a_joinPoint);
        if (hasAccess == Boolean.FALSE) {
            String entityName = entityValidator.getEntityName(requestObject, roleNames, a_joinPoint);
            if (entityName == null) {
                logger.error("No record found for " + moduleName, (Object)moduleName);
                responseObject.sendError(HttpStatus.NOT_FOUND.value());
                return null;
            }
            logger.error("You do not have enough privilege to access: " + moduleName + " : " + entityName, (Object)entityName);
            String requestUri = requestObject.getRequestURI().substring(requestObject.getContextPath().length());
            if (requestUri.startsWith("/error")) {
                if (this.moduleListingRepository.getIsHomePageByUrl(entityName) == 1) {
                    ApplicationContextUtils.getThreadLocal().set(403);
                } else {
                    responseObject.sendError(HttpStatus.FORBIDDEN.value(), "You do not have enough privilege to access this module");
                }
            } else if (roleNames.contains("ANONYMOUS")) {
                requestObject.getSession().setAttribute("CUSTOM_REDIRECT_URL", (Object)requestObject.getRequestURL());
                StringBuilder redirectUrl = new StringBuilder().append(this.servletContext.getContextPath()).append("/cf/login");
                responseObject.sendRedirect(redirectUrl.toString());
            } else {
                responseObject.sendError(HttpStatus.FORBIDDEN.value(), "You do not have enough privilege to access this module");
            }
            return null;
        }
        ApplicationContextUtils.getThreadLocal().set(200);
        return a_joinPoint.proceed();
    }

    private HttpServletRequest getRequest() {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return sra.getRequest();
    }

    private HttpServletResponse getResponse() {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return sra.getResponse();
    }
}

