/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.RandomStringUtils;

public final class CaptchaUtil {
    public static final String FILE_TYPE = "png";
    private static final Random random = new Random();
    private static final List<Color[]> ColourSet = new ArrayList<Color[]>();
    static String path = "D:/Captcha";

    private CaptchaUtil() {
        throw new RuntimeException("This is singleton class. Please don't try to initiate this class");
    }

    public static void generateCaptcha(Dimension size, String captchaStr, OutputStream outputStream) throws Throwable {
        int width = size.width;
        int height = size.height;
        Color[] colours = CaptchaUtil.getColours();
        Color backgroundColor = colours[0];
        Color foregroundColor = colours[1];
        Font font = new Font("Comic Sans Serif", 1, 20);
        BufferedImage cpimg = new BufferedImage(width, height, 1);
        Graphics2D graphics = cpimg.createGraphics();
        graphics.setFont(font);
        graphics.setColor(backgroundColor);
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(foregroundColor);
        AffineTransform orig = null;
        int xPos = 10;
        boolean isEven = true;
        for (char c : captchaStr.toCharArray()) {
            orig = graphics.getTransform();
            orig.rotate(Math.toRadians(CaptchaUtil.gRPNV(20, -20)), 0.0, 0.0);
            Font rotatedFont = font.deriveFont(orig);
            graphics.setFont(rotatedFont);
            graphics.drawString("" + c, xPos, 35);
            xPos += 20;
            isEven = !isEven;
        }
        for (int iCounter = 12; iCounter <= 60; iCounter += 12) {
            Graphics2D graphics2d = (Graphics2D)cpimg.getGraphics();
            AlphaComposite alphaChannel = AlphaComposite.getInstance(3, 0.7f);
            graphics2d.setComposite(alphaChannel);
            graphics2d.setColor(foregroundColor);
            FontMetrics fontMetrics = graphics2d.getFontMetrics();
            String watermarkText = RandomStringUtils.random((int)20, (boolean)true, (boolean)false);
            Rectangle2D rectangle = fontMetrics.getStringBounds(watermarkText, graphics2d);
            int centerX = (cpimg.getWidth() - (int)rectangle.getWidth()) / 2;
            int centerY = iCounter;
            graphics2d.drawString(watermarkText, centerX, centerY);
        }
        CaptchaUtil.drawLines(foregroundColor, size, graphics);
        ImageIO.write((RenderedImage)cpimg, FILE_TYPE, outputStream);
    }

    private static void drawLines(Color lineColor, Dimension size, Graphics graphics) {
        int lineGap = 5;
        int horizontalCount = (int)Math.ceil(size.height / lineGap);
        int verticalCount = (int)Math.ceil(size.width / lineGap);
        AlphaComposite alphaChannel = AlphaComposite.getInstance(3, 0.7f);
        ((Graphics2D)graphics).setComposite(alphaChannel);
        graphics.setColor(lineColor);
        for (int iHorizontalCounter = 0; iHorizontalCounter < horizontalCount; ++iHorizontalCounter) {
            graphics.drawLine(5, 10 * iHorizontalCounter, size.width, 10 * iHorizontalCounter);
        }
        for (int iVerticalCounter = 0; iVerticalCounter < verticalCount; ++iVerticalCounter) {
            graphics.drawLine(15 * iVerticalCounter, 2, 15 * iVerticalCounter, size.height);
        }
    }

    public static int gRPNV(int max, int min) {
        int ii = min + (int)(Math.random() * (double)(max - min + 1));
        return ii;
    }

    private static Color[] getColours() {
        int randomNum = random.nextInt(ColourSet.size() - 1 + 1) + 0;
        return ColourSet.get(randomNum);
    }

    public static String getCaptchaString() {
        String CHARACTERS = "abcdefghjklmnpqrstuvwxyz23456789";
        String CHARACTER_NUMBERS = "23456789";
        char[] charArray = "abcdefghjklmnpqrstuvwxyz23456789".toCharArray();
        char[] numberCharArray = "23456789".toCharArray();
        String captchaStr = RandomStringUtils.random((int)6, (int)0, (int)"abcdefghjklmnpqrstuvwxyz23456789".length(), (boolean)true, (boolean)true, (char[])charArray).toUpperCase();
        ArrayList<Integer> digits = new ArrayList<Integer>();
        Object digitStr = "";
        for (int i = 0; i < captchaStr.length(); ++i) {
            if (Character.isDigit(captchaStr.charAt(i))) {
                digitStr = (String)digitStr + captchaStr.charAt(i);
                continue;
            }
            if (((String)digitStr).isEmpty()) continue;
            digits.add(Integer.parseInt((String)digitStr));
            digitStr = "";
        }
        if (!((String)digitStr).isEmpty()) {
            digits.add(Integer.parseInt((String)digitStr));
            digitStr = "";
        }
        if (digits.isEmpty()) {
            captchaStr = captchaStr.replace(Character.toString(captchaStr.charAt(4)), RandomStringUtils.random((int)1, (char[])numberCharArray));
            captchaStr = captchaStr.replace(Character.toString(captchaStr.charAt(1)), RandomStringUtils.random((int)1, (char[])numberCharArray));
        }
        return captchaStr;
    }

    public static int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    private static String[] getCharacters() {
        int i;
        String[] chars = new String[36];
        for (i = 0; i < 10; ++i) {
            chars[i] = "" + i;
        }
        for (i = 10; i < 36; ++i) {
            chars[i] = "" + (char)(i + 55);
        }
        for (i = 36; i < 62; ++i) {
        }
        List<String> stringList = Arrays.asList(chars);
        Collections.shuffle(stringList);
        stringList.toArray(chars);
        return chars;
    }

    private static String generateCaptchaString(Random random) {
        int length = 6;
        StringBuffer captchaStringBuffer = new StringBuffer();
        int[] ignoreCharNumbers = new int[]{48, 49, 73, 79, 105, 108, 111};
        for (int i = 0; i < length; ++i) {
            int baseCharNumber = Math.abs(random.nextInt()) % 62;
            int charNumber = 0;
            charNumber = baseCharNumber < 26 ? 65 + baseCharNumber : (baseCharNumber < 52 ? 97 + (baseCharNumber - 26) : 48 + (baseCharNumber - 52));
            int charPresent = Arrays.binarySearch(ignoreCharNumbers, charNumber);
            if (charPresent <= -1) {
                captchaStringBuffer.append((char)charNumber);
                continue;
            }
            captchaStringBuffer.append((char)(charNumber += 4));
        }
        return captchaStringBuffer.toString().toUpperCase();
    }

    static {
        ColourSet.add(new Color[]{new Color(0, 161, 143), new Color(255, 255, 255)});
        ColourSet.add(new Color[]{new Color(0, 0, 0), new Color(255, 255, 255)});
        ColourSet.add(new Color[]{new Color(255, 255, 255), new Color(0, 0, 0)});
        ColourSet.add(new Color[]{new Color(11, 97, 254), new Color(255, 255, 255)});
        ColourSet.add(new Color[]{new Color(254, 125, 11), new Color(255, 255, 255)});
    }
}

