/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.dbutils.spi.PropertyMasterDetails;
import com.trigyn.jws.usermanagement.entities.JwsUser;
import com.trigyn.jws.usermanagement.exception.InvalidLoginException;
import com.trigyn.jws.usermanagement.repository.UserManagementDAO;
import com.trigyn.jws.usermanagement.service.JwsUserService;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class CustomLoginFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    @Autowired
    private PropertyMasterDetails propertyMasterDetails = null;
    @Autowired
    private JwsUserService userService = null;
    @Autowired
    private UserManagementDAO userManagementDAO = null;
    @Autowired
    private ServletContext servletContext = null;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        try {
            String emailID = request.getParameter("email");
            JwsUser user = this.userService.findUserByEmail(emailID);
            Integer maxFailedCount = Integer.parseInt(this.propertyMasterDetails.getSystemPropertyValue("maxFailedCount"));
            if (user != null) {
                if (user.getIsActive() == 1) {
                    if (user.getFailedAttempt() <= maxFailedCount) {
                        user.setFailedAttempt(user.getFailedAttempt() + 1);
                        if (user.getFailedAttempt() == maxFailedCount.intValue()) {
                            user.setIsActive(0);
                        }
                        this.userManagementDAO.updateUserData(user);
                        if (user.getFailedAttempt() == maxFailedCount.intValue()) {
                            exception = new InvalidLoginException("Account Locked. Please contact Admin.");
                        } else {
                            String msg = exception.getMessage();
                            if (msg.startsWith("?")) {
                                msg = "Login failed. Bad credentials.";
                            }
                            exception = new InvalidLoginException(msg);
                        }
                    } else {
                        exception = new InvalidLoginException("Account Locked. Please contact Admin.");
                    }
                } else {
                    exception = new InvalidLoginException("Account Locked. Please contact Admin.");
                }
            } else {
                exception = new InvalidLoginException("User does not exist.");
            }
            super.setDefaultFailureUrl("/cf/login");
            super.onAuthenticationFailure(request, response, exception);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

