/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.usermanagement.repository.JwsRoleMasterModulesAssociationRepository;
import com.trigyn.jws.usermanagement.security.config.ApplicationSecurityDetails;
import com.trigyn.jws.usermanagement.security.config.UserInformation;
import com.trigyn.jws.usermanagement.utils.Constants;
import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;

public class CustomPermissionEvaluator
implements PermissionEvaluator {
    private ApplicationSecurityDetails applicationSecurityDetails = null;
    @Autowired
    private JwsRoleMasterModulesAssociationRepository roleModuleRepository = null;

    public CustomPermissionEvaluator(ApplicationSecurityDetails applicationSecurityDetails) {
        this.applicationSecurityDetails = applicationSecurityDetails;
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        ArrayList<String> roleNames = new ArrayList<String>();
        if (this.applicationSecurityDetails.getIsAuthenticationEnabled().booleanValue() && !(authentication instanceof AnonymousAuthenticationToken)) {
            UserInformation userInformation = (UserInformation)authentication.getPrincipal();
            roleNames.addAll(userInformation.getRoles());
        } else {
            if (!this.applicationSecurityDetails.getIsAuthenticationEnabled().booleanValue()) {
                return true;
            }
            roleNames.add("ANONYMOUS");
        }
        Long count = this.roleModuleRepository.checkModulePresentForCurrentRole(roleNames, permission.toString(), Constants.ISACTIVE);
        return count > 0L;
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        return false;
    }
}

