/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.dbutils.service.PropertyMasterService;
import com.trigyn.jws.usermanagement.entities.JwsUser;
import com.trigyn.jws.usermanagement.exception.InvalidLoginException;
import com.trigyn.jws.usermanagement.repository.JwsUserRepository;
import com.trigyn.jws.usermanagement.repository.JwsUserRoleAssociationRepository;
import com.trigyn.jws.usermanagement.security.config.TwoFactorGoogleUtil;
import com.trigyn.jws.usermanagement.security.config.UserInformation;
import com.trigyn.jws.usermanagement.service.UserConfigService;
import com.trigyn.jws.usermanagement.utils.Constants;
import com.trigyn.jws.usermanagement.vo.JwsRoleVO;
import com.trigyn.jws.usermanagement.vo.JwsUserLoginVO;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DefaultUserDetailsServiceImpl
implements UserDetailsService {
    private static final Logger logger = LogManager.getLogger(DefaultUserDetailsServiceImpl.class);
    private JwsUserRepository userRepository = null;
    private JwsUserRoleAssociationRepository userRoleAssociationRepository = null;
    private UserConfigService userConfigService = null;
    @Autowired
    private PropertyMasterService propertyMasterService = null;

    public DefaultUserDetailsServiceImpl(JwsUserRepository userRepository, JwsUserRoleAssociationRepository userRoleAssociationRepository, UserConfigService userConfigService) {
        this.userRepository = userRepository;
        this.userRoleAssociationRepository = userRoleAssociationRepository;
        this.userConfigService = userConfigService;
    }

    @Transactional(readOnly=true)
    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = sra.getRequest();
        HttpSession session = request.getSession();
        HashMap<String, Object> mapDetails = new HashMap<String, Object>();
        try {
            this.userConfigService.getConfigurableDetails(mapDetails);
        }
        catch (Exception a_excep) {
            logger.error("Error ocurred.", (Throwable)a_excep);
        }
        JwsUser user = this.userRepository.findByEmailIgnoreCase(email);
        if (user == null) {
            throw new UsernameNotFoundException("Not found!");
        }
        List multiAuthLoginVOs = (List)mapDetails.get("activeAutenticationDetails");
        if (multiAuthLoginVOs != null && !multiAuthLoginVOs.isEmpty()) {
            for (JwsUserLoginVO multiAuthLogin : multiAuthLoginVOs) {
                Map<String, Object> loginAttributes;
                if (Constants.AuthType.DAO.getAuthType() != multiAuthLogin.getAuthenticationType() || (loginAttributes = multiAuthLogin.getLoginAttributes()) == null || loginAttributes.isEmpty()) continue;
                loginAttributes.containsKey("enableCaptcha");
                if (!loginAttributes.containsKey("enableCaptcha")) continue;
                String captcaValue = (String)loginAttributes.get("enableCaptcha");
                if (captcaValue != null && captcaValue.equalsIgnoreCase("true") && !request.getParameter("captcha").equals(session.getAttribute("loginCaptcha").toString())) {
                    session.removeAttribute("loginCaptcha");
                    throw new InvalidLoginException("Please verify captcha!");
                }
                if (!loginAttributes.containsKey("verificationType")) continue;
                String verificationTypeValue = (String)loginAttributes.get("verificationType");
                if (verificationTypeValue != null && verificationTypeValue.equals(Constants.VerificationType.TOTP.getVerificationType())) {
                    user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)new TwoFactorGoogleUtil().getTOTPCode(user.getSecretKey())));
                }
                if (verificationTypeValue == null || !verificationTypeValue.equals(Constants.VerificationType.OTP.getVerificationType()) || user.getOneTimePassword() == null || user.getOtpRequestedTime() == null) continue;
                try {
                    Date otpSentTime = user.getOtpRequestedTime();
                    Date currentTime = Calendar.getInstance().getTime();
                    long maxOtpActiveTime = Long.valueOf(this.propertyMasterService.findPropertyMasterValue("otp_expiry_time"));
                    long diffInMinutes = TimeUnit.MILLISECONDS.toMinutes(currentTime.getTime() - otpSentTime.getTime());
                    if (diffInMinutes > maxOtpActiveTime) {
                        throw new InvalidLoginException("Invalid OTP. Please verify again!");
                    }
                    user.setPassword(user.getOneTimePassword());
                }
                catch (Exception exception) {
                    throw new InvalidLoginException("Invalid OTP. Please verify again!");
                }
            }
        }
        List<JwsRoleVO> rolesVOs = this.userRoleAssociationRepository.getUserRoles(Constants.ISACTIVE, user.getUserId());
        return new UserInformation(user, rolesVOs);
    }
}

