/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.usermanagement.repository.AuthorizedValidatorDAO;
import com.trigyn.jws.usermanagement.repository.JwsEntityRoleAssociationRepository;
import com.trigyn.jws.usermanagement.security.config.EntityValidator;
import com.trigyn.jws.usermanagement.utils.Constants;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicFormEntityValidator
implements EntityValidator {
    private static final Logger logger = LogManager.getLogger(DynamicFormEntityValidator.class);
    @Autowired
    private AuthorizedValidatorDAO authorizedValidatorDAO = null;
    @Autowired
    private JwsEntityRoleAssociationRepository entityRoleAssociationRepository = null;
    private String primaryKeyName = "formId";

    @Override
    public boolean hasAccessToEntity(HttpServletRequest reqObject, List<String> roleNames, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside DynamicFormEntityValidator.hasAccessToEntity(formId - {}, reqObject - {}, roleNames - {}, a_joinPoint - {})", (Object)reqObject.getParameter(this.primaryKeyName), (Object)reqObject, roleNames, (Object)a_joinPoint);
        boolean hasAccess = false;
        Long count = this.authorizedValidatorDAO.hasAccessToCurrentDynamicForm(reqObject.getParameter(this.primaryKeyName), roleNames);
        if (count > 0L) {
            hasAccess = true;
        }
        return hasAccess;
    }

    @Override
    public String getEntityName(HttpServletRequest reqObject, List<String> roleNameList, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside DynamicFormEntityValidator.getEntityName(formId - {}, reqObject - {}, roleNameList - {}, a_joinPoint - {})", (Object)reqObject.getParameter(this.primaryKeyName), (Object)reqObject, roleNameList, (Object)a_joinPoint);
        String dynamicFormId = reqObject.getParameter(this.primaryKeyName);
        String dynamicFormName = this.authorizedValidatorDAO.getDynamicFormNameById(dynamicFormId);
        return this.entityRoleAssociationRepository.getEntityNameByEntityAndRoleId(Constants.Modules.DYNAMICFORM.getModuleName(), dynamicFormName);
    }
}

