/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.usermanagement.repository.AuthorizedValidatorDAO;
import com.trigyn.jws.usermanagement.repository.JwsEntityRoleAssociationRepository;
import com.trigyn.jws.usermanagement.security.config.EntityValidator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicRestEntityValidator
implements EntityValidator {
    private static final Logger logger = LogManager.getLogger(DynamicRestEntityValidator.class);
    @Autowired
    private AuthorizedValidatorDAO authorizedValidatorDAO = null;
    @Autowired
    private JwsEntityRoleAssociationRepository entityRoleAssociationRepository = null;

    @Override
    public boolean hasAccessToEntity(HttpServletRequest reqObject, List<String> roleNames, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside DynamicRestEntityValidator.hasAccessToEntity(requestURI - {}, reqObject - {}, roleNames - {}, a_joinPoint - {})", (Object)reqObject.getRequestURI(), (Object)reqObject, roleNames, (Object)a_joinPoint);
        boolean hasAccess = false;
        String requestUri = reqObject.getRequestURI().substring(reqObject.getContextPath().length());
        requestUri = requestUri.startsWith("/japi/") ? requestUri.replaceFirst("/japi/", "") : requestUri.replaceFirst("/api/", "");
        String requestType = reqObject.getMethod();
        Long count = this.authorizedValidatorDAO.hasAccessToDynamicRest(requestUri, requestType, roleNames);
        if (count > 0L) {
            hasAccess = true;
        }
        return hasAccess;
    }

    @Override
    public String getEntityName(HttpServletRequest reqObject, List<String> roleNameList, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside DynamicRestEntityValidator.getEntityName(requestURI - {}, reqObject - {}, roleNameList - {}, a_joinPoint - {})", (Object)reqObject.getRequestURI(), (Object)reqObject, roleNameList, (Object)a_joinPoint);
        String requestUri = reqObject.getRequestURI().substring(reqObject.getContextPath().length());
        requestUri = requestUri.startsWith("/japi/") ? requestUri.replaceFirst("/japi/", "") : requestUri.replaceFirst("/api/", "");
        return this.entityRoleAssociationRepository.getEntityNameByEntityAndRoleId("REST API", requestUri);
    }
}

