/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.usermanagement.repository.AuthorizedValidatorDAO;
import com.trigyn.jws.usermanagement.repository.JwsEntityRoleAssociationRepository;
import com.trigyn.jws.usermanagement.security.config.EntityValidator;
import com.trigyn.jws.usermanagement.utils.Constants;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileBinEntityValidator
implements EntityValidator {
    private static final Logger logger = LogManager.getLogger(FileBinEntityValidator.class);
    @Autowired
    private AuthorizedValidatorDAO authorizedValidatorDAO = null;
    @Autowired
    private JwsEntityRoleAssociationRepository entityRoleAssociationRepository = null;
    private String primaryKeyName = "fileUploadId";

    @Override
    public boolean hasAccessToEntity(HttpServletRequest reqObject, List<String> roleNames, ProceedingJoinPoint a_joinPoint) {
        Long count;
        logger.debug("Inside FileBinEntityValidator.hasAccessToEntity(fileUploadId - {}, reqObject - {}, roleNames - {}, a_joinPoint - {})", (Object)reqObject.getParameter(this.primaryKeyName), (Object)reqObject, roleNames, (Object)a_joinPoint);
        String fileUploadId = reqObject.getParameter(this.primaryKeyName);
        String fileBinId = reqObject.getParameter("fileBinId");
        boolean hasAccess = false;
        if (StringUtils.isBlank((CharSequence)fileBinId)) {
            if (StringUtils.isBlank((CharSequence)fileUploadId)) {
                fileUploadId = reqObject.getRequestURI();
                fileUploadId = fileUploadId.replaceFirst("/cf/files/", "");
            }
            fileBinId = this.authorizedValidatorDAO.getFileBinIdByFileUploadId(fileUploadId);
        }
        if ((count = this.authorizedValidatorDAO.hasAccessToEntity(Constants.Modules.FILEBIN.getModuleName(), fileBinId, roleNames)) != null && count > 0L) {
            hasAccess = true;
        }
        return hasAccess;
    }

    @Override
    public String getEntityName(HttpServletRequest reqObject, List<String> roleNameList, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside FileBinEntityValidator.getEntityName(fileUploadId - {}, reqObject - {}, roleNameList - {}, a_joinPoint - {})", (Object)reqObject, (Object)reqObject.getParameter(this.primaryKeyName), roleNameList, (Object)a_joinPoint);
        String fileUploadId = reqObject.getParameter(this.primaryKeyName);
        String fileBinId = reqObject.getParameter("fileBinId");
        if (StringUtils.isBlank((CharSequence)fileBinId)) {
            if (StringUtils.isBlank((CharSequence)fileUploadId)) {
                fileUploadId = reqObject.getRequestURI();
                fileUploadId = fileUploadId.replaceFirst("/cf/files/", "");
            }
            fileBinId = this.authorizedValidatorDAO.getFileBinIdByFileUploadId(fileUploadId);
        }
        return this.entityRoleAssociationRepository.getEntityNameByEntityAndRoleId(Constants.Modules.FILEBIN.getModuleName(), fileBinId);
    }
}

