/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.usermanagement.repository.AuthorizedValidatorDAO;
import com.trigyn.jws.usermanagement.repository.JwsEntityRoleAssociationRepository;
import com.trigyn.jws.usermanagement.security.config.EntityValidator;
import com.trigyn.jws.usermanagement.utils.Constants;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GridEntityValidator
implements EntityValidator {
    private static final Logger logger = LogManager.getLogger(GridEntityValidator.class);
    @Autowired
    private AuthorizedValidatorDAO authorizedValidatorDAO = null;
    @Autowired
    private JwsEntityRoleAssociationRepository entityRoleAssociationRepository = null;
    private String primaryKeyName = "gridId";
    private String moduleId = "07067149-098d-11eb-9a16-f48e38ab9348";

    @Override
    public boolean hasAccessToEntity(HttpServletRequest reqObject, List<String> roleNames, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside GridEntityValidator.hasAccessToEntity(gridId - {}, reqObject - {}, roleNames - {}, a_joinPoint - {})", (Object)reqObject.getParameter(this.primaryKeyName), (Object)reqObject, roleNames, (Object)a_joinPoint);
        boolean hasAccess = false;
        Long count = this.authorizedValidatorDAO.hasAccessToGridUtils(reqObject.getParameter(this.primaryKeyName), roleNames, this.moduleId);
        if (count > 0L) {
            hasAccess = true;
        }
        return hasAccess;
    }

    @Override
    public String getEntityName(HttpServletRequest reqObject, List<String> roleNameList, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside GridEntityValidator.getEntityName(gridId - {}, reqObject - {}, roleNameList - {}, a_joinPoint - {})", (Object)reqObject.getParameter(this.primaryKeyName), (Object)reqObject, roleNameList, (Object)a_joinPoint);
        String gridId = reqObject.getParameter(this.primaryKeyName);
        String gridName = this.authorizedValidatorDAO.getGridNameByGridId(gridId);
        return this.entityRoleAssociationRepository.getEntityNameByEntityAndRoleId(Constants.Modules.GRIDUTILS.getModuleName(), gridName);
    }
}

