/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.usermanagement.repository.AuthorizedValidatorDAO;
import com.trigyn.jws.usermanagement.repository.JwsEntityRoleAssociationRepository;
import com.trigyn.jws.usermanagement.security.config.EntityValidator;
import com.trigyn.jws.usermanagement.utils.Constants;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelManualEntityValidator
implements EntityValidator {
    private static final Logger logger = LogManager.getLogger(HelManualEntityValidator.class);
    @Autowired
    private AuthorizedValidatorDAO authorizedValidatorDAO = null;
    @Autowired
    private JwsEntityRoleAssociationRepository entityRoleAssociationRepository = null;

    @Override
    public boolean hasAccessToEntity(HttpServletRequest reqObject, List<String> roleNames, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside HelManualEntityValidator.hasAccessToEntity(manualType - {}, reqObject - {}, roleNames - {}, a_joinPoint - {})", (Object)reqObject.getParameter("mt"), (Object)reqObject, roleNames, (Object)a_joinPoint);
        String manualType = reqObject.getParameter("mt");
        String isNew = reqObject.getParameter("ie");
        boolean hasAccess = false;
        Long count = this.authorizedValidatorDAO.hasAccessToEntity(Constants.Modules.HELPMANUAL.getModuleName(), manualType, roleNames);
        if (count > 0L || !StringUtils.isBlank((CharSequence)isNew) && isNew.equals("0")) {
            hasAccess = true;
        }
        return hasAccess;
    }

    @Override
    public String getEntityName(HttpServletRequest reqObject, List<String> roleNameList, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside HelManualEntityValidator.getEntityName(manualType - {}, reqObject - {}, roleNameList - {}, a_joinPoint - {})", (Object)reqObject.getParameter("mt"), (Object)reqObject, roleNameList, (Object)a_joinPoint);
        String manualType = reqObject.getParameter("mt");
        String manualName = this.authorizedValidatorDAO.getManualNameById(manualType);
        return this.entityRoleAssociationRepository.getEntityNameByEntityAndRoleId(Constants.Modules.HELPMANUAL.getModuleName(), manualName);
    }
}

