/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.dbutils.spi.IUserDetailsService;
import com.trigyn.jws.dbutils.vo.UserDetailsVO;
import com.trigyn.jws.usermanagement.security.config.UserInformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class JwsUserDetailsService
implements IUserDetailsService {
    private UserDetailsVO detailsVO = null;

    public UserDetailsVO getUserDetails() {
        HttpServletRequest requestObject = this.getRequest();
        Authentication authentication = null;
        if (requestObject != null && requestObject.getSession().getAttribute("SPRING_SECURITY_CONTEXT") != null) {
            authentication = ((SecurityContextImpl)requestObject.getSession().getAttribute("SPRING_SECURITY_CONTEXT")).getAuthentication();
        }
        if (authentication == null) {
            authentication = SecurityContextHolder.getContext().getAuthentication();
        }
        if (authentication != null && Boolean.FALSE.equals(authentication instanceof AnonymousAuthenticationToken)) {
            this.detailsVO = new UserDetailsVO();
            UserInformation userInformation = (UserInformation)authentication.getPrincipal();
            this.detailsVO.setUserName(userInformation.getUsername());
            this.detailsVO.setUserId(userInformation.getUserId());
            this.detailsVO.setFullName(userInformation.getFullName());
            ArrayList roleList = new ArrayList();
            roleList.addAll(AuthorityUtils.authorityListToSet((Collection)authentication.getAuthorities()));
            this.detailsVO.setRoleIdList(roleList);
        } else {
            this.detailsVO = new UserDetailsVO("anonymous-user", "anonymous", Arrays.asList("anonymous"), "anonymous-user");
        }
        return this.detailsVO;
    }

    public List<String> getUsersRoleHavingAccessToJWS() {
        return this.detailsVO.getRoleIdList();
    }

    private HttpServletRequest getRequest() {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (sra != null) {
            return sra.getRequest();
        }
        return null;
    }
}

