/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.trigyn.jws.usermanagement.security.config.ApplicationSecurityDetails;
import com.trigyn.jws.usermanagement.security.config.JwtUtil;
import com.trigyn.jws.usermanagement.utils.Constants;
import com.trigyn.jws.usermanagement.vo.MultiAuthSecurityDetailsVO;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.SignatureException;
import java.io.IOException;
import java.net.URL;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=0x7FFFFFFF)
public class JwtRequestFilter
extends OncePerRequestFilter {
    private static final Logger logger = LogManager.getLogger(JwtRequestFilter.class);
    @Autowired
    @Lazy
    private UserDetailsService userDetailsService = null;
    @Autowired
    @Lazy
    private JwtUtil jwtUtil = null;
    @Autowired
    private ApplicationSecurityDetails applicationSecurityDetails = null;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        Map<String, Object> authenticationDetails = this.applicationSecurityDetails.getAuthenticationDetails();
        try {
            List multiAuthLogiVos;
            if (authenticationDetails != null && (multiAuthLogiVos = (List)authenticationDetails.get("authenticationDetails")) != null && !multiAuthLogiVos.isEmpty()) {
                for (MultiAuthSecurityDetailsVO multiAuthLogin : multiAuthLogiVos) {
                    Integer authType = multiAuthLogin.getAuthenticationTypeVO().getId();
                    String authorizationHeader = request.getHeader("Authorization");
                    String username = null;
                    String jwt = null;
                    String requestUri = request.getRequestURI().substring(request.getContextPath().length());
                    if ((!requestUri.startsWith("/japi/") || requestUri.equals("/japi/error")) && (authorizationHeader == null || !authorizationHeader.startsWith("Bearer "))) continue;
                    if (requestUri.startsWith("/japi/") && !requestUri.equals("/japi/error")) {
                        if (authType == Constants.AuthType.DAO.getAuthType() || authType == Constants.AuthType.LDAP.getAuthType()) {
                            if (authorizationHeader != null && authorizationHeader.startsWith("Bearer ")) {
                                jwt = authorizationHeader.substring(7);
                                username = this.jwtUtil.extractUsername(jwt);
                            }
                        } else if (authType == Constants.AuthType.OAUTH.getAuthType() && authorizationHeader != null && authorizationHeader.startsWith("Bearer ") && (username = this.retrieveUsernameFromJwtToken(jwt = authorizationHeader.substring(7))) == null) {
                            jwt = authorizationHeader.substring(7);
                            username = this.jwtUtil.extractUsername(jwt);
                        }
                        if (jwt != null && username != null) break;
                    }
                    if ((!requestUri.startsWith("/japi/") || requestUri.equals("/japi/error") || username == null || SecurityContextHolder.getContext().getAuthentication() != null) && username == null) continue;
                    UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
                    if ((authType != Constants.AuthType.DAO.getAuthType() && authType != Constants.AuthType.LDAP.getAuthType() || !this.jwtUtil.validateToken(jwt, userDetails).booleanValue()) && authType != Constants.AuthType.OAUTH.getAuthType()) continue;
                    UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                    usernamePasswordAuthenticationToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                    SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
                    break;
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (ExpiredJwtException expiredException) {
            logger.error("Inside JwtRequestFilter - Error occurred while processing the request (Request URI: {}})", (Object)request.getRequestURI(), (Object)expiredException);
            response.sendError(500, expiredException.getMessage());
            return;
        }
        catch (SignatureException signatureException) {
            logger.error("Inside JwtRequestFilter - Error occurred while processing the request (Request URI: {}})", (Object)request.getRequestURI(), (Object)signatureException);
            response.sendError(500, signatureException.getMessage());
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            logger.error("Inside JwtRequestFilter - Error occurred while processing the request (Request URI: {}})", (Object)request.getRequestURI(), (Object)throwable);
            if (throwable.getCause() instanceof AccessDeniedException) {
                response.sendError(403, "You do not have enough privilege to access this module");
            } else {
                response.sendError(500, throwable.getMessage());
            }
            return;
        }
    }

    private String retrieveUsernameFromJwtToken(String token) throws Exception {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            UrlJwkProvider provider = null;
            Jwk jwk = null;
            Algorithm algorithm = null;
            provider = new UrlJwkProvider(new URL("https://login.microsoftonline.com/common/discovery/keys"));
            System.out.println(jwt.getKeyId());
            jwk = provider.get(jwt.getKeyId());
            algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
            algorithm.verify(jwt);
            return jwt.getClaim("upn").asString();
        }
        catch (Exception a_exc) {
            logger.error("Error while retrieving user name from jwt token of OAUTH authentication", (Throwable)a_exc);
            return null;
        }
    }
}

