/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.usermanagement.repository.JwsUserRepository;
import com.trigyn.jws.usermanagement.repository.JwsUserRoleAssociationRepository;
import com.trigyn.jws.usermanagement.security.config.ApplicationSecurityDetails;
import com.trigyn.jws.usermanagement.security.config.CustomAuthSuccessHandler;
import com.trigyn.jws.usermanagement.security.config.CustomLoginFailureHandler;
import com.trigyn.jws.usermanagement.security.config.CustomLogoutSuccessHandler;
import com.trigyn.jws.usermanagement.security.config.DefaultUserDetailsServiceImpl;
import com.trigyn.jws.usermanagement.security.config.JwtAuthenticationEntryPoint;
import com.trigyn.jws.usermanagement.security.config.JwtRequestFilter;
import com.trigyn.jws.usermanagement.service.UserConfigService;
import com.trigyn.jws.usermanagement.utils.Constants;
import com.trigyn.jws.usermanagement.vo.DropDownData;
import com.trigyn.jws.usermanagement.vo.JwsAuthAdditionalProperty;
import com.trigyn.jws.usermanagement.vo.JwsAuthConfiguration;
import com.trigyn.jws.usermanagement.vo.JwsAuthVerificationType;
import com.trigyn.jws.usermanagement.vo.JwsMultiAuthVerificationVO;
import com.trigyn.jws.usermanagement.vo.MultiAuthSecurityDetailsVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.rememberme.JdbcTokenRepositoryImpl;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;

@EnableWebSecurity
public class MultiHttpSecurityConfig {
    private static final Logger logger = LogManager.getLogger(MultiHttpSecurityConfig.class);
    @Autowired
    private UserDetailsService userDetailsService = null;
    @Autowired
    private AuthenticationSuccessHandler customAuthSuccessHandler = null;
    @Autowired
    private LogoutHandler customLogoutSuccessHandler = null;
    @Autowired
    private ApplicationSecurityDetails applicationSecurityDetails = null;
    @Autowired
    private PasswordEncoder passwordEncoder = null;
    @Autowired
    private DataSource dataSource = null;
    private static List<String> clients = new ArrayList<String>();
    @Autowired
    private JwtRequestFilter jwtRequestFilter = null;
    @Autowired
    private ServletContext servletContext = null;
    @Autowired
    private JwtAuthenticationEntryPoint jwtAuthenticationEntryPoint = null;

    @Bean
    @ConditionalOnMissingBean
    public UserDetailsService userDetailsService(JwsUserRepository userRepository, JwsUserRoleAssociationRepository userRoleAssociationRepository, UserConfigService userConfigService) {
        return new DefaultUserDetailsServiceImpl(userRepository, userRoleAssociationRepository, userConfigService);
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationSuccessHandler authenticationSuccessHandler() {
        return new CustomAuthSuccessHandler();
    }

    @Bean
    public CustomLoginFailureHandler loginFailureHandler() {
        return new CustomLoginFailureHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public LogoutHandler logoutHandler() {
        return new CustomLogoutSuccessHandler();
    }

    @Bean
    public PersistentTokenRepository tokenRepository() {
        JdbcTokenRepositoryImpl jdbcTokenRepositoryImpl = new JdbcTokenRepositoryImpl();
        jdbcTokenRepositoryImpl.setDataSource(this.dataSource);
        return jdbcTokenRepositoryImpl;
    }

    private ClientRegistrationRepository clientRegistrationRepository() {
        List multiAuthSecurityDetails;
        ArrayList<ClientRegistration> registrations = new ArrayList<ClientRegistration>();
        Map<String, Object> authenticationDetails = this.applicationSecurityDetails.getAuthenticationDetails();
        if (authenticationDetails != null && (multiAuthSecurityDetails = (List)authenticationDetails.get("authenticationDetails")) != null) {
            for (MultiAuthSecurityDetailsVO authSecurityDetail : multiAuthSecurityDetails) {
                JwsMultiAuthVerificationVO oAuthType;
                Integer authType = authSecurityDetail.getAuthenticationTypeVO().getId();
                if (authType == null || Constants.AuthType.OAUTH.getAuthType() != authType || (oAuthType = authSecurityDetail.getVerificationTypeVO()).getVerificationType() == null || oAuthType.getConfigurations() == null) continue;
                List<JwsAuthConfiguration> configurations = oAuthType.getConfigurations();
                for (JwsAuthConfiguration oAuthConfiguration : configurations) {
                    List<DropDownData> dropDownDatas = oAuthConfiguration.getDropDownData();
                    for (DropDownData dropDownData : dropDownDatas) {
                        if (clients.contains(dropDownData.getName())) continue;
                        clients.add(dropDownData.getName());
                        ClientRegistration client = this.getRegistration(dropDownData);
                        if (client == null) continue;
                        registrations.add(client);
                    }
                }
            }
        }
        return new InMemoryClientRegistrationRepository(registrations);
    }

    private ClientRegistration getRegistration(DropDownData dropDownData) {
        if (dropDownData == null) {
            return null;
        }
        String clientName = dropDownData.getName();
        String clientId = null;
        String clientSecret = null;
        List<JwsAuthAdditionalProperty> additionalProperties = dropDownData.getAdditionalProperties();
        if (additionalProperties == null) {
            return null;
        }
        JwsAuthAdditionalProperty oAuthClientId = dropDownData.getAdditionalProperties().stream().filter(additionalProperty -> additionalProperty != null && additionalProperty.getName().equalsIgnoreCase("client-id")).findAny().orElse(null);
        JwsAuthAdditionalProperty oAuthClientSecret = dropDownData.getAdditionalProperties().stream().filter(additionalProperty -> additionalProperty != null && additionalProperty.getName().equalsIgnoreCase("client-secret")).findAny().orElse(null);
        if (oAuthClientId != null) {
            clientId = oAuthClientId.getValue();
        }
        if (oAuthClientSecret != null) {
            clientSecret = oAuthClientSecret.getValue();
        }
        if (clientId == null || clientSecret == null) {
            return null;
        }
        if (clientName.equals("google")) {
            return CommonOAuth2Provider.GOOGLE.getBuilder(clientName).clientId(clientId).clientSecret(clientSecret).build();
        }
        if (clientName.equals("facebook")) {
            return CommonOAuth2Provider.FACEBOOK.getBuilder(clientName).clientId(clientId).clientSecret(clientSecret).build();
        }
        if (clientName.equals("github")) {
            return CommonOAuth2Provider.GITHUB.getBuilder(clientName).clientId(clientId).clientSecret(clientSecret).build();
        }
        if (clientName.equals("office365")) {
            String redirectUri = String.format("%s%s/login/oauth2/code/office365", this.applicationSecurityDetails.getBaseUrl(), this.servletContext.getContextPath());
            return ClientRegistration.withRegistrationId((String)"office365").clientId(clientId).clientSecret(clientSecret).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).scope(new String[]{"openid"}).redirectUriTemplate(redirectUri).authorizationUri("https://login.microsoftonline.com/common/oauth2/authorize").tokenUri("https://login.microsoftonline.com/common/oauth2/token").jwkSetUri("https://login.microsoftonline.com/common/discovery/keys").build();
        }
        return null;
    }

    @Configuration
    @Order(value=2)
    public class WebSecurityConfig
    extends WebSecurityConfigurerAdapter {
        protected void configure(AuthenticationManagerBuilder auth) throws Exception {
            List multiAuthSecurityDetails;
            Map<String, Object> authenticationDetails = MultiHttpSecurityConfig.this.applicationSecurityDetails.getAuthenticationDetails();
            if (authenticationDetails != null && (multiAuthSecurityDetails = (List)authenticationDetails.get("authenticationDetails")) != null && !multiAuthSecurityDetails.isEmpty()) {
                for (MultiAuthSecurityDetailsVO multiAuthLogin : multiAuthSecurityDetails) {
                    Integer authType = multiAuthLogin.getAuthenticationTypeVO().getId();
                    if (authenticationDetails == null) continue;
                    if (authType == null) {
                        auth.inMemoryAuthentication().withUser("root@trigyn.com").password(MultiHttpSecurityConfig.this.passwordEncoder.encode((CharSequence)"root")).roles(new String[]{"ADMIN"});
                        continue;
                    }
                    if (Constants.AuthType.INMEMORY.getAuthType() == authType) {
                        auth.inMemoryAuthentication().withUser("root@trigyn.com").password(MultiHttpSecurityConfig.this.passwordEncoder.encode((CharSequence)"root")).roles(new String[]{"ADMIN"});
                    }
                    if (Constants.AuthType.DAO.getAuthType() == authType) {
                        auth.userDetailsService(MultiHttpSecurityConfig.this.userDetailsService).passwordEncoder(MultiHttpSecurityConfig.this.passwordEncoder);
                    }
                    if (Constants.AuthType.LDAP.getAuthType() == authType) {
                        // empty if block
                    }
                    if (Constants.AuthType.OAUTH.getAuthType() != authType) continue;
                }
            }
        }

        protected void configure(HttpSecurity http) throws Exception {
            Map<String, Object> authenticationDetails = MultiHttpSecurityConfig.this.applicationSecurityDetails.getAuthenticationDetails();
            if (authenticationDetails != null) {
                List multiAuthLogiVos = (List)authenticationDetails.get("authenticationDetails");
                if (!multiAuthLogiVos.isEmpty() && MultiHttpSecurityConfig.this.applicationSecurityDetails.getIsAuthenticationEnabled().booleanValue()) {
                    for (MultiAuthSecurityDetailsVO multiAuthLogin : multiAuthLogiVos) {
                        if (multiAuthLogin != null) {
                            List<JwsAuthConfiguration> configurations;
                            List selectedDropDownData;
                            Integer authType = multiAuthLogin.getAuthenticationTypeVO().getId();
                            JwsAuthVerificationType authVerificationType = multiAuthLogin.getVerificationTypeVO().getVerificationType();
                            Boolean enableVerification = Boolean.valueOf(authVerificationType.getValue());
                            if (!enableVerification.booleanValue()) continue;
                            if (Constants.AuthType.INMEMORY.getAuthType() == authType) {
                                // empty if block
                            }
                            if (Constants.AuthType.DAO.getAuthType() == authType) {
                                ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/webjars/**"})).permitAll().antMatchers(new String[]{"/"})).permitAll().antMatchers(new String[]{"/cf/createPassword", "/cf/sendResetPasswordMail", "/cf/resetPasswordPage", "/cf/sendResetPasswordMail", "/cf/resetPassword", "/cf/authenticate", "/cf/saveOtpAndSendMail"})).permitAll().antMatchers(new String[]{"/cf/register", "/cf/confirm-account", "/cf/captcha/**", "/cf/changePassword", "/cf/updatePassword", "/cf/configureTOTP", "/cf/sendConfigureTOTPMail", "/cf/**", "/", "/view/**", "/cf/gl"})).permitAll().and()).csrf().disable()).formLogin().loginPage("/cf/login").usernameParameter("email").permitAll()).failureHandler((AuthenticationFailureHandler)MultiHttpSecurityConfig.this.loginFailureHandler())).successHandler(MultiHttpSecurityConfig.this.customAuthSuccessHandler)).and()).rememberMe().rememberMeParameter("remember-me").tokenRepository(MultiHttpSecurityConfig.this.tokenRepository()).and()).logout().addLogoutHandler(MultiHttpSecurityConfig.this.customLogoutSuccessHandler).deleteCookies(new String[]{"JSESSIONID"}).invalidateHttpSession(true);
                            }
                            if (Constants.AuthType.LDAP.getAuthType() == authType) {
                                // empty if block
                            }
                            if (Constants.AuthType.OAUTH.getAuthType() != authType || (selectedDropDownData = (configurations = multiAuthLogin.getVerificationTypeVO().getConfigurations()).stream().filter(configuration -> configuration.getDropDownData() != null).flatMap(dropDownDatas -> dropDownDatas.getDropDownData().stream()).filter(dropDownData -> dropDownData.getSelected() != null && dropDownData.getSelected() != false).collect(Collectors.toList())) == null || selectedDropDownData.size() <= 0) continue;
                            ((HttpSecurity)((HttpSecurity)((OAuth2LoginConfigurer)((OAuth2LoginConfigurer)((OAuth2LoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/cf/confirm-account"})).denyAll().antMatchers(new String[]{"/webjars/**"})).permitAll().antMatchers(new String[]{"/login/**", "/logout/**"})).permitAll().antMatchers(new String[]{"/cf/files/**", "/view/**", "/cf/gl", "/cf/psdf"})).permitAll().antMatchers(new String[]{"/cf/**"})).authenticated().and()).oauth2Login().clientRegistrationRepository(MultiHttpSecurityConfig.this.clientRegistrationRepository()).loginPage("/cf/login").permitAll()).failureHandler((AuthenticationFailureHandler)MultiHttpSecurityConfig.this.loginFailureHandler())).successHandler(MultiHttpSecurityConfig.this.customAuthSuccessHandler)).and()).logout().addLogoutHandler(MultiHttpSecurityConfig.this.customLogoutSuccessHandler).and()).csrf().disable();
                            continue;
                        }
                        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/cf/createPassword", "/cf/sendResetPasswordMail", "/cf/resetPasswordPage", "/cf/sendResetPasswordMail", "/cf/resetPassword", "/cf/login"})).denyAll().antMatchers(new String[]{"/cf/register", "/cf/confirm-account", "/cf/captcha/**", "/cf/changePassword", "/cf/updatePassword", "/cf/configureTOTP", "/cf/sendConfigureTOTPMail"})).denyAll().antMatchers(new String[]{"/cf/**", "/view/**", "/"})).permitAll().and()).csrf().disable();
                    }
                } else {
                    ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/cf/createPassword", "/cf/sendResetPasswordMail", "/cf/resetPasswordPage", "/cf/sendResetPasswordMail", "/cf/resetPassword", "/cf/login"})).denyAll().antMatchers(new String[]{"/cf/register", "/cf/confirm-account", "/cf/captcha/**", "/cf/changePassword", "/cf/updatePassword", "/cf/configureTOTP", "/cf/sendConfigureTOTPMail"})).denyAll().antMatchers(new String[]{"/cf/**", "/view/**", "/"})).permitAll().and()).csrf().disable();
                }
            } else {
                ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/cf/createPassword", "/cf/sendResetPasswordMail", "/cf/resetPasswordPage", "/cf/sendResetPasswordMail", "/cf/resetPassword", "/cf/login"})).denyAll().antMatchers(new String[]{"/cf/register", "/cf/confirm-account", "/cf/captcha/**", "/cf/changePassword", "/cf/updatePassword", "/cf/configureTOTP", "/cf/sendConfigureTOTPMail"})).denyAll().antMatchers(new String[]{"/cf/**", "/view/**", "/"})).permitAll().and()).csrf().disable();
            }
        }
    }

    @Configuration
    @Order(value=1)
    public class ApiSecurityAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        private JwtAuthenticationEntryPoint jwtAuthenticationEntryPoint = null;

        @Bean
        public AuthenticationManager authenticationManagerBean() throws Exception {
            return super.authenticationManagerBean();
        }

        protected void configure(AuthenticationManagerBuilder auth) throws Exception {
            auth.userDetailsService(MultiHttpSecurityConfig.this.userDetailsService).passwordEncoder(MultiHttpSecurityConfig.this.passwordEncoder);
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/japi/**").authorizeRequests().antMatchers(new String[]{"/japi/register", "/japi/login", "/japi/error"})).permitAll().anyRequest()).authenticated().and()).csrf().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.jwtAuthenticationEntryPoint).and()).addFilterBefore((Filter)MultiHttpSecurityConfig.this.jwtRequestFilter, UsernamePasswordAuthenticationFilter.class).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }
    }
}

