/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.usermanagement.repository.AuthorizedValidatorDAO;
import com.trigyn.jws.usermanagement.repository.JwsEntityRoleAssociationRepository;
import com.trigyn.jws.usermanagement.security.config.EntityValidator;
import com.trigyn.jws.usermanagement.utils.Constants;
import com.trigyn.jws.usermanagement.vo.SiteLayoutVO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SiteLayoutEntityValidator
implements EntityValidator {
    private static final Logger logger = LogManager.getLogger(SiteLayoutEntityValidator.class);
    @Autowired
    private AuthorizedValidatorDAO authorizedValidatorDAO = null;
    @Autowired
    private JwsEntityRoleAssociationRepository entityRoleAssociationRepository = null;

    @Override
    public boolean hasAccessToEntity(HttpServletRequest reqObject, List<String> roleNames, ProceedingJoinPoint a_joinPoint) {
        SiteLayoutVO siteLayoutVO;
        logger.debug("Inside SiteLayoutEntityValidator.hasAccessToEntity(requestURI - {}, reqObject - {}, roleNames - {}, a_joinPoint - {})", (Object)reqObject.getRequestURI(), (Object)reqObject, roleNames, (Object)a_joinPoint);
        boolean hasAccess = false;
        Long count = 0L;
        String moduleUrlStr = reqObject.getRequestURI().substring(reqObject.getContextPath().length());
        String requestUrl = moduleUrlStr = moduleUrlStr.replaceFirst("/view/", "");
        if (moduleUrlStr.indexOf("/") != -1) {
            moduleUrlStr = moduleUrlStr.substring(0, moduleUrlStr.indexOf("/"));
        }
        if ((siteLayoutVO = this.hasAccessToSiteLayout(reqObject, moduleUrlStr, roleNames)) != null && siteLayoutVO.getRoleCount() != null) {
            count = siteLayoutVO.getRoleCount();
        } else if (reqObject.getQueryString() != null) {
            StringBuilder moduleUrl = new StringBuilder(requestUrl).append("?").append(reqObject.getQueryString());
            count = this.authorizedValidatorDAO.hasAccessToSiteLayout(moduleUrl.toString(), roleNames);
        }
        if (count > 0L) {
            hasAccess = true;
        }
        return hasAccess;
    }

    private SiteLayoutVO hasAccessToSiteLayout(HttpServletRequest reqObject, String moduleUrlStr, List<String> roleNames) {
        SiteLayoutVO siteLayoutVO = null;
        List<Object> siteLayoutVOList = new ArrayList();
        StringBuilder moduleUrl = new StringBuilder();
        StringBuilder fixedModuleUrl = new StringBuilder();
        siteLayoutVOList = roleNames != null ? this.entityRoleAssociationRepository.hasAccessToSiteLayout(moduleUrlStr, roleNames, Constants.ISACTIVE) : this.entityRoleAssociationRepository.getSiteLayoutNameByUrl(moduleUrlStr);
        List<String> pathVariableList = this.getPathVariables(reqObject);
        for (String pathVariable : pathVariableList) {
            if (!StringUtils.isBlank((CharSequence)moduleUrl)) {
                moduleUrl.append("/");
                fixedModuleUrl.append("/");
            }
            moduleUrl.append(pathVariable);
            fixedModuleUrl.append(pathVariable);
            moduleUrl.append("/**");
            for (SiteLayoutVO siteLayoutVO2 : siteLayoutVOList) {
                String moduleUrlDB = siteLayoutVO2.getModuleUrl();
                if (StringUtils.isBlank((CharSequence)moduleUrlDB) || !moduleUrlDB.equals(moduleUrl.toString()) && !moduleUrlDB.equals(fixedModuleUrl.toString())) continue;
                return siteLayoutVO2;
            }
            moduleUrl.delete(moduleUrl.indexOf("/**"), moduleUrl.length());
        }
        if (siteLayoutVO == null && CollectionUtils.isEmpty(pathVariableList) && !CollectionUtils.isEmpty(siteLayoutVOList)) {
            siteLayoutVO = (SiteLayoutVO)siteLayoutVOList.get(0);
        }
        return siteLayoutVO;
    }

    @Override
    public String getEntityName(HttpServletRequest reqObject, List<String> roleNameList, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside SiteLayoutEntityValidator.getEntityName(requestURI - {}, reqObject - {}, roleNameList - {}, a_joinPoint - {})", (Object)reqObject.getRequestURI(), (Object)reqObject, roleNameList, (Object)a_joinPoint);
        String moduleUrl = reqObject.getRequestURI().substring(reqObject.getContextPath().length());
        String requestUrl = moduleUrl = moduleUrl.replaceFirst("/view/", "");
        if (moduleUrl.indexOf("/") != -1) {
            moduleUrl = moduleUrl.substring(0, moduleUrl.indexOf("/"));
        }
        SiteLayoutVO siteLayoutVO = this.hasAccessToSiteLayout(reqObject, moduleUrl, null);
        String moduleName = null;
        if (siteLayoutVO != null) {
            moduleName = siteLayoutVO.getModuleName();
        } else if (reqObject.getQueryString() != null) {
            StringBuilder moduleUrlStr = new StringBuilder(requestUrl).append("?").append(reqObject.getQueryString());
            moduleName = this.authorizedValidatorDAO.getSiteLayoutModuleNameByUrl(moduleUrlStr.toString());
        }
        return this.entityRoleAssociationRepository.getEntityNameByEntityAndRoleId(Constants.Modules.SITELAYOUT.getModuleName(), moduleName);
    }

    private List<String> getPathVariables(HttpServletRequest httpServletRequest) {
        List<String> pathVariableList = new ArrayList<String>();
        String moduleUrl = httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
        if ((moduleUrl = moduleUrl.replaceFirst("/view/", "")).indexOf("/") != -1) {
            pathVariableList = Stream.of(moduleUrl.split("/")).map(urlElement -> new String((String)urlElement)).collect(Collectors.toList());
        }
        return pathVariableList;
    }
}

