/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.usermanagement.repository.AuthorizedValidatorDAO;
import com.trigyn.jws.usermanagement.repository.JwsEntityRoleAssociationRepository;
import com.trigyn.jws.usermanagement.security.config.EntityValidator;
import com.trigyn.jws.usermanagement.utils.Constants;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TemplateEntityValidator
implements EntityValidator {
    private static final Logger logger = LogManager.getLogger(TemplateEntityValidator.class);
    @Autowired
    private AuthorizedValidatorDAO authorizedValidatorDAO = null;
    @Autowired
    private JwsEntityRoleAssociationRepository entityRoleAssociationRepository = null;

    @Override
    public boolean hasAccessToEntity(HttpServletRequest reqObject, List<String> roleNames, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside TemplateEntityValidator.hasAccessToEntity(templateName - {}, reqObject - {}, roleNames - {}, a_joinPoint - {})", (Object)a_joinPoint.getArgs()[0].toString(), (Object)reqObject, roleNames, (Object)a_joinPoint);
        String templateName = a_joinPoint.getArgs()[0].toString();
        boolean hasAccess = false;
        Long count = this.authorizedValidatorDAO.hasAccessToTemplate(templateName, roleNames);
        if (count > 0L) {
            hasAccess = true;
        }
        return hasAccess;
    }

    @Override
    public String getEntityName(HttpServletRequest reqObject, List<String> roleNameList, ProceedingJoinPoint a_joinPoint) {
        logger.debug("Inside TemplateEntityValidator.getEntityName(templateName - {}, reqObject - {}, roleNameList - {}, a_joinPoint - {})", (Object)a_joinPoint.getArgs()[0].toString(), (Object)reqObject, roleNameList, (Object)a_joinPoint);
        String templateName = a_joinPoint.getArgs()[0].toString();
        return this.entityRoleAssociationRepository.getEntityNameByEntityAndRoleId(Constants.Modules.TEMPLATING.getModuleName(), templateName);
    }
}

