/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import de.taimos.totp.TOTP;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class TwoFactorGoogleUtil {
    private static final Logger logger = LogManager.getLogger(TwoFactorGoogleUtil.class);

    public void validateOTP(String enteredCode, String secretKey) {
        if (enteredCode.equals(this.getTOTPCode(secretKey))) {
            System.out.println("Logged in successfully");
        } else {
            System.out.println("Invalid 2FA Code");
        }
    }

    public void createQRCode(String barCodeData, OutputStream outputStream, int height, int width) {
        try {
            BitMatrix matrix = new MultiFormatWriter().encode(barCodeData, BarcodeFormat.QR_CODE, width, height);
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)outputStream);
        }
        catch (Throwable a_th) {
            logger.error("Error ocurred.", a_th);
        }
    }

    public String getGoogleAuthenticatorBarCode(String account, String issuer, String secretKey) {
        try {
            return "otpauth://totp/" + URLEncoder.encode(issuer + ":" + account, "UTF-8").replace("+", "%20") + "?secret=" + URLEncoder.encode(secretKey, "UTF-8").replace("+", "%20") + "&issuer=" + URLEncoder.encode(issuer, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException a_unSupEncExc) {
            logger.error("Error ocurred.", (Throwable)a_unSupEncExc);
            throw new IllegalStateException(a_unSupEncExc);
        }
    }

    public String generateSecretKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base32 base32 = new Base32();
        return base32.encodeToString(bytes);
    }

    public String getTOTPCode(String secretKey) {
        Base32 base32 = new Base32();
        byte[] bytes = base32.decode(secretKey);
        String hexKey = Hex.encodeHexString((byte[])bytes);
        return TOTP.getOTP((String)hexKey);
    }
}

