/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config;

import com.trigyn.jws.usermanagement.entities.JwsUser;
import com.trigyn.jws.usermanagement.vo.JwsRoleVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;

public class UserInformation
implements UserDetails,
OAuth2User,
OidcUser {
    private static final long serialVersionUID = -1617042842214166605L;
    private String userName = null;
    private String password = null;
    private boolean active = Boolean.FALSE;
    private String fullName = null;
    private String userId = null;
    private boolean isDefaultPassword = Boolean.FALSE;
    private List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    private List<String> roles = new ArrayList<String>();
    private Map<String, Object> oAuthAttributes = new HashMap<String, Object>();

    public UserInformation() {
    }

    public UserInformation(JwsUser user, List<JwsRoleVO> roleVOs) {
        this.userId = user.getUserId();
        this.userName = user.getEmail();
        this.password = user.getPassword();
        this.fullName = user.getFirstName() + " " + user.getLastName();
        boolean bl = user.getIsActive() != null ? user.getIsActive() == 1 : (this.active = false);
        this.isDefaultPassword = user.getForcePasswordChange() != null ? user.getForcePasswordChange() == 1 : false;
        for (JwsRoleVO jwsRoleVO : roleVOs) {
            SimpleGrantedAuthority authority = new SimpleGrantedAuthority(jwsRoleVO.getRoleName());
            this.roles.add(jwsRoleVO.getRoleName());
            this.authorities.add((GrantedAuthority)authority);
        }
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.userName;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.active;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public boolean isDefaultPassword() {
        return this.isDefaultPassword;
    }

    public void setDefaultPassword(boolean isDefaultPassword) {
        this.isDefaultPassword = isDefaultPassword;
    }

    public Map<String, Object> getAttributes() {
        return this.oAuthAttributes;
    }

    public String getName() {
        return this.fullName;
    }

    public UserInformation create(JwsUser user, Map<String, Object> attributes, List<JwsRoleVO> roleVOs) {
        for (JwsRoleVO jwsRoleVO : roleVOs) {
            SimpleGrantedAuthority authority = new SimpleGrantedAuthority(jwsRoleVO.getRoleName());
            this.roles.add(jwsRoleVO.getRoleName());
            this.authorities.add((GrantedAuthority)authority);
        }
        return new UserInformation(user, roleVOs);
    }

    public Map<String, Object> getClaims() {
        return null;
    }

    public OidcUserInfo getUserInfo() {
        return null;
    }

    public OidcIdToken getIdToken() {
        return null;
    }
}

